/***********************************************************
 *
 * Service Runner framework runner using commons-daemon
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.runner.monitoring;

import org.clazzes.svc.api.monitoring.HealthInfo;
import org.clazzes.svc.api.monitoring.HealthStatus;

public class HealthCheckResult extends Result<HealthInfo> {

    public HealthCheckResult(HealthInfo result) {
        super(result);
    }

    public HealthCheckResult(Throwable e) {
        super(new HealthInfo(
                e instanceof Error ?
                    HealthStatus.HEALTH_CHECK_ERROR :
                    HealthStatus.CRITICAL,
                e.getMessage()
             ),e);
    }

    @Override
    public boolean isValid() {
        return this.getResult() != null && this.getResult().getStatus() != HealthStatus.HEALTH_CHECK_ERROR;
    }

    @Override
    public Number getNumericResult() {

        HealthInfo r = this.getResult();
        return r == null ? null : Double.valueOf(r.getStatus().getValue());
    }

}
