/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.monitoring.system;

import java.util.List;
import java.util.Locale;
import org.clazzes.svc.api.monitoring.HealthInfo;
import org.clazzes.svc.api.monitoring.HealthStatus;
import org.clazzes.svc.runner.monitoring.system.SystemHealthCheckSupport;

public class MemoryHealthCheck
extends SystemHealthCheckSupport {
    private static final double MB_FACTOR = 9.5367431640625E-7;

    public MemoryHealthCheck(double warningPercentage, double criticalPercentage) {
        super(warningPercentage, criticalPercentage);
    }

    public HealthInfo call() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        double totalMB = (double)runtime.totalMemory() * 9.5367431640625E-7;
        double freeMB = (double)runtime.freeMemory() * 9.5367431640625E-7;
        double percentage = 100.0 * (1.0 - freeMB / totalMB);
        if (percentage < this.warningPercentage) {
            return new HealthInfo(HealthStatus.OK, String.format(Locale.ENGLISH, "Memory usage [%.1f%%<%.1f%%], free memory [%.1fMiB/%.1fMiB]", percentage, this.warningPercentage, freeMB, totalMB));
        }
        if (percentage < this.criticalPercentage) {
            return new HealthInfo(HealthStatus.WARN, String.format(Locale.ENGLISH, "Memory usage [%.1f%%\u2264%.1f%%<%.1f%%], free memory [%.1fMiB/%.1fMiB]", this.warningPercentage, percentage, this.criticalPercentage, freeMB, totalMB));
        }
        return new HealthInfo(HealthStatus.CRITICAL, String.format(Locale.ENGLISH, "Memory usage [%.1f%%\u2264%.1f%%], free memory [%.1fMiB/%.1fMiB]", this.criticalPercentage, percentage, freeMB, totalMB));
    }

    public String getId() {
        return "system.memory";
    }

    public String getDescription() {
        return "Check the memory usage against Thresholds [warn=" + this.warningPercentage + "%,critical=" + this.criticalPercentage + "%]";
    }

    public List<String> getTags() {
        return List.of("system", "memory");
    }
}

