/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.monitoring.system;

import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.clazzes.svc.api.monitoring.HealthInfo;
import org.clazzes.svc.api.monitoring.HealthStatus;
import org.clazzes.svc.runner.monitoring.system.SystemHealthCheckSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskHealthCheck
extends SystemHealthCheckSupport {
    private static final Logger log = LoggerFactory.getLogger(DiskHealthCheck.class);
    private static final double GB_FACTOR = 9.313225746154785E-10;

    public DiskHealthCheck(double warningPercentage, double criticalPercentage) {
        super(warningPercentage, criticalPercentage);
    }

    public HealthInfo call() throws Exception {
        FileSystem fileSystem = FileSystems.getDefault();
        double totalGB = 0.0;
        double freeGB = 0.0;
        int ndirs = 0;
        for (Path path : fileSystem.getRootDirectories()) {
            FileStore store = Files.getFileStore(path);
            if (log.isDebugEnabled()) {
                log.debug("store={},total={},usable={}", new Object[]{store, store.getTotalSpace(), store.getUsableSpace()});
            }
            totalGB += (double)store.getTotalSpace() * 9.313225746154785E-10;
            freeGB += (double)store.getUsableSpace() * 9.313225746154785E-10;
            ++ndirs;
        }
        if (ndirs == 0) {
            return new HealthInfo(HealthStatus.HEALTH_CHECK_ERROR, "Cannot find any root directory.");
        }
        double percentage = 100.0 * (1.0 - freeGB / totalGB);
        if (percentage < this.warningPercentage) {
            return new HealthInfo(HealthStatus.OK, String.format(Locale.ENGLISH, "Disk usage [%.1f%%<%.1f%%], free [%.1fGiB/%.1fGiB]", percentage, this.warningPercentage, freeGB, totalGB));
        }
        if (percentage < this.criticalPercentage) {
            return new HealthInfo(HealthStatus.WARN, String.format(Locale.ENGLISH, "Disk usage [%.1f%%\u2264%.1f%%<%.1f%%], free [%.1fGiB/%.1fGiB]", this.warningPercentage, percentage, this.criticalPercentage, freeGB, totalGB));
        }
        return new HealthInfo(HealthStatus.CRITICAL, String.format(Locale.ENGLISH, "Disk usage [%.1f%%\u2264%.1f%%], free [%.1fGiB/%.1fGiB]", this.criticalPercentage, percentage, freeGB, totalGB));
    }

    public String getId() {
        return "system.disk";
    }

    public String getDescription() {
        return "Check the Disk usage against Thresholds [warn=" + this.warningPercentage + "%,critical=" + this.criticalPercentage + "%]";
    }

    public List<String> getTags() {
        return List.of("system", "disk");
    }
}

