/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.monitoring.openmetrics;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.TreeMap;
import org.clazzes.svc.runner.monitoring.IActiveMetrics;
import org.clazzes.svc.runner.monitoring.IActiveMonitoring;
import org.clazzes.svc.runner.monitoring.openmetrics.OpenMetricsFormatter;

public class OpenMetricsServlet
extends HttpServlet {
    private static final String CONTENT_TYPE = "application/openmetrics-text;version=1.0.0;charset=utf-8";
    private static final String UI_CONTENT_TYPE = "text/plain;charset=utf-8";
    private final IActiveMonitoring monitoring;

    public OpenMetricsServlet(IActiveMonitoring monitoring) {
        this.monitoring = monitoring;
    }

    private static final void setNoCacheHeaders(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Expires", "0");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String[] ids = req.getParameterValues("id");
        String[] tags = req.getParameterValues("tag");
        boolean ui = req.getParameter("ui") != null;
        TreeMap selectedMetrics = new TreeMap();
        if (ids == null && tags == null) {
            selectedMetrics.putAll(this.monitoring.getHealthChecks());
            selectedMetrics.putAll(this.monitoring.getCounters());
            selectedMetrics.putAll(this.monitoring.getGauges());
        } else {
            if (ids != null) {
                for (String id : ids) {
                    this.monitoring.getById(id).ifPresent(m -> selectedMetrics.put(id, (IActiveMetrics<?>)m));
                }
            }
            if (tags != null) {
                for (String tag : tags) {
                    for (IActiveMetrics<?> m2 : this.monitoring.getByTag(tag)) {
                        selectedMetrics.put(m2.getTaggedMetrics().getId(), m2);
                    }
                }
            }
        }
        resp.setContentType(ui ? UI_CONTENT_TYPE : CONTENT_TYPE);
        OpenMetricsServlet.setNoCacheHeaders(resp);
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)resp.getOutputStream());){
            for (Map.Entry e : selectedMetrics.entrySet()) {
                OpenMetricsFormatter.formatMetrics(w, (IActiveMetrics)e.getValue());
            }
        }
    }
}

