/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.monitoring;

public abstract class Result<T extends Comparable<T>>
implements Comparable<Result<T>> {
    private final long nanoTime = System.nanoTime();
    private final long epochMillis = System.currentTimeMillis();
    private final T result;
    private final Throwable exception;
    private Long nanosDuration;

    public Result(T result) {
        this.result = result;
        this.exception = null;
    }

    public Result(Throwable exception) {
        this.result = null;
        this.exception = exception;
    }

    public Result(T result, Throwable exception) {
        this.result = result;
        this.exception = exception;
    }

    public long getNanoTime() {
        return this.nanoTime;
    }

    public long getEpochMillis() {
        return this.epochMillis;
    }

    public T getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public abstract boolean isValid();

    public abstract Number getNumericResult();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.nanoTime ^ this.nanoTime >>> 32);
        result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
        return result;
    }

    public void calculateDuration(long startNanos) {
        this.nanosDuration = this.nanoTime - startNanos;
    }

    public Long getNanosDuration() {
        return this.nanosDuration;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Result other = (Result)obj;
        if (this.nanoTime != other.nanoTime) {
            return false;
        }
        return !(this.result == null ? other.result != null : !this.result.equals(other.result));
    }

    @Override
    public int compareTo(Result<T> o) {
        int r = this.result == null ? (o.getResult() == null ? 0 : -1) : (o.getResult() == null ? 1 : this.result.compareTo(o.getResult()));
        if (r != 0) {
            return r;
        }
        return Long.signum(this.nanoTime - o.getNanoTime());
    }

    public String toString() {
        return "Result [nanoTime=" + this.nanoTime + ", epochMillis=" + this.epochMillis + ", result=" + String.valueOf(this.result) + ", exception=" + String.valueOf(this.exception) + ", nanosDuration=" + this.nanosDuration + "]";
    }
}

