package org.clazzes.svc.runner.monitoring.system;

import org.clazzes.svc.api.monitoring.HealthCheck;

public abstract class SystemHealthCheckSupport implements HealthCheck {

    protected final double warningPercentage;
    protected final double criticalPercentage;

    public SystemHealthCheckSupport(double warningPercentage, double criticalPercentage) {
        this.warningPercentage = warningPercentage;
        this.criticalPercentage = criticalPercentage;
    }

    public double getWarningPercentage() {
        return this.warningPercentage;
    }

    public double getCriticalPercentage() {
        return this.criticalPercentage;
    }


}
