package org.clazzes.svc.runner.monitoring.system;

import java.util.List;

import org.clazzes.svc.api.ComponentInfo;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ComponentState;
import org.clazzes.svc.api.monitoring.HealthCheck;
import org.clazzes.svc.api.monitoring.HealthInfo;
import org.clazzes.svc.api.monitoring.HealthStatus;

public class ComponentsHealthCheck implements HealthCheck {

    private final ComponentManager componentManager;

    public ComponentsHealthCheck(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    @Override
    public HealthInfo call() throws Exception {

        List<ComponentInfo> components = this.componentManager.listComponents();

        HealthStatus status = HealthStatus.HEALTH_CHECK_ERROR;

        int ncommitted = 0;

        for (ComponentInfo comp : components) {
            if (comp.getState() == ComponentState.COMMITTED) {
                if (status == HealthStatus.HEALTH_CHECK_ERROR) {
                    status = HealthStatus.OK;
                }
                ++ncommitted;
            }
            else if (comp.getState() == ComponentState.STARTED) {
                if (status == HealthStatus.HEALTH_CHECK_ERROR ||
                    status == HealthStatus.OK) {
                    status = HealthStatus.WARN;
                }
            }
            else {
                status = HealthStatus.CRITICAL;
            }
        }

        String msg = status == HealthStatus.OK ?
           "All ["+components.size()+"] components are commited." :
           "Only ["+ ncommitted + "/" + components.size()+"] components are commited.";


        return new HealthInfo(status,msg);
    }

    @Override
    public String getId() {
        return "system.components";
    }

    @Override
    public String getDescription() {
        return "Check whether all Java components are properly started";
    }

    @Override
    public List<String> getTags() {
        return List.of("system","components");
    }

}
