/***********************************************************
 *
 * Service Runner framework runner using commons-daemon
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.runner.monitoring;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.clazzes.svc.api.monitoring.HealthInfo;

public interface IActiveMonitoring {

    public Map<String, IActiveMetrics<HealthInfo>> getHealthChecks();

    public IActiveMetrics<HealthInfo> getHealthCheck(String key);

    public Map<String, IActiveMetrics<Long>> getCounters();

    public IActiveMetrics<Long> getCounter(String key);

    public Map<String, IActiveMetrics<Double>> getGauges();

    public IActiveMetrics<Double> getGauge(String key);

    public List<IActiveMetrics<?>> getByTag(String tag);

    public Optional<IActiveMetrics<?>> getById(String id);
}