/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.jetty;

import jakarta.servlet.Servlet;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ConfigWrapper;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServicePriority;
import org.clazzes.svc.api.ServiceRegistry;
import org.eclipse.jetty.ee10.servlet.ErrorHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.ServletMapping;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLogWriter;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServicePriority(value=7)
public class JettyComponent
implements Component {
    public static final String PID = "org.clazzes.svc.runner.jetty";
    private static final Logger log = LoggerFactory.getLogger(JettyComponent.class);
    private Server server;
    private AutoCloseable servletRegistration;
    private final Map<String, ServletHolder> servlets = new ConcurrentHashMap<String, ServletHolder>();

    public void start(ServiceContext svcCtxt) throws Exception {
        ConfigurationEngine configurationEngine = (ConfigurationEngine)svcCtxt.getService(ConfigurationEngine.class).get();
        ComponentManager componentManager = (ComponentManager)svcCtxt.getService(ComponentManager.class).get();
        configurationEngine.listen(PID, config -> {
            try {
                this.stop(svcCtxt);
            }
            catch (Exception e) {
                log.warn("Error stopping jetty component", (Throwable)e);
            }
            try {
                int port = config.getInt("port", 8088);
                int nthreads = config.getInt("nthreads", 8);
                QueuedThreadPool threadPool = new QueuedThreadPool(nthreads);
                threadPool.setName("svc-runner-jetty");
                Server jettyServer = new Server((ThreadPool)threadPool);
                ErrorHandler errorHandler = new ErrorHandler();
                errorHandler.setShowMessageInTitle(config.getBoolean("showMessageInTitle", false));
                errorHandler.setShowOrigin(config.getBoolean("showOrigin", false));
                errorHandler.setShowCauses(config.getBoolean("showCauses", false));
                errorHandler.setShowStacks(config.getBoolean("showStacks", false));
                jettyServer.setErrorHandler((Request.Handler)errorHandler);
                jettyServer.setRequestLog((RequestLog)new CustomRequestLog((RequestLog.Writer)new Slf4jRequestLogWriter(), "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\""));
                HttpConfiguration httpConfiguration = new HttpConfiguration();
                httpConfiguration.setSendServerVersion(config.getBoolean("sendServerVersion", false));
                HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
                ServerConnector connector = new ServerConnector(jettyServer, new ConnectionFactory[]{httpConnectionFactory});
                connector.setPort(port);
                jettyServer.addConnector((Connector)connector);
                ServletContextHandler servletHandler = new ServletContextHandler();
                ConfigWrapper resourceTree = config.getSubTree("resources");
                if (resourceTree == null) {
                    jettyServer.setHandler((Handler)servletHandler);
                } else {
                    Handler.Sequence handlers = new Handler.Sequence(new Handler[0]);
                    for (String path : resourceTree.keySet()) {
                        Path fileSystemPath = (Path)resourceTree.getMandatoryParsed(x$0 -> Path.of(x$0, new String[0]), path);
                        if (Files.isDirectory(fileSystemPath, new LinkOption[0])) {
                            log.info("Adding static resource [{}] as path [{}].", (Object)fileSystemPath, (Object)path);
                            ResourceHandler resourceHandler = new ResourceHandler();
                            resourceHandler.setBaseResource(ResourceFactory.of((Container)resourceHandler).newResource(fileSystemPath));
                            ContextHandler contextHandler = new ContextHandler((Handler)resourceHandler, path);
                            handlers.addHandler((Handler)contextHandler);
                            continue;
                        }
                        log.warn("Configured resource [{}] for path [{}] is not a directory, skipping it.", (Object)fileSystemPath, (Object)path);
                    }
                    handlers.addHandler((Handler)servletHandler);
                    jettyServer.setHandler((Handler)handlers);
                }
                final AtomicBoolean started = new AtomicBoolean(false);
                jettyServer.addEventListener((EventListener)new LifeCycle.Listener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void lifeCycleFailure(LifeCycle event, Throwable cause) {
                        log.error("Start of jetty failed:", cause);
                        JettyComponent jettyComponent = JettyComponent.this;
                        synchronized (jettyComponent) {
                            started.set(true);
                            JettyComponent.this.notifyAll();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void lifeCycleStarted(LifeCycle event) {
                        log.info("Start of jetty finished successfully.");
                        JettyComponent jettyComponent = JettyComponent.this;
                        synchronized (jettyComponent) {
                            started.set(true);
                            JettyComponent.this.notifyAll();
                        }
                    }
                });
                jettyServer.start();
                log.info("Waiting for full jetty startup...");
                JettyComponent jettyComponent = this;
                synchronized (jettyComponent) {
                    if (!started.get()) {
                        this.wait(60000L);
                    }
                }
                log.info("Wait for full jetty startup finished with result [{}].", (Object)started.get());
                if (!started.get()) {
                    log.warn("Jetty did not start up witin ohne minute, server might be most likely inoperable.");
                }
                ServiceRegistry registry = (ServiceRegistry)svcCtxt.getService(ServiceRegistry.class).get();
                this.servletRegistration = registry.listenAll(Servlet.class, (key, servlet) -> {
                    JettyComponent jettyComponent = this;
                    synchronized (jettyComponent) {
                        log.info("Adding servlet [{}] for path [{}]", (Object)servlet.getServletInfo(), key);
                        ServletHolder holder = new ServletHolder(servlet);
                        servletHandler.addServlet(holder, key);
                        this.servlets.put((String)key, holder);
                    }
                }, (key, servlet) -> {
                    JettyComponent jettyComponent = this;
                    synchronized (jettyComponent) {
                        ServletHolder holder = this.servlets.remove(key);
                        if (holder != null) {
                            try {
                                log.info("Stopping servlet holder for path [{}]", key);
                                holder.stop();
                                ServletHandler h = servletHandler.getServletHandler();
                                ServletMapping[] mappings = h.getServletMappings();
                                if (mappings.length > 0) {
                                    Object[] newm = new ServletMapping[mappings.length - 1];
                                    int nnew = 0;
                                    for (ServletMapping m : mappings) {
                                        boolean matches = false;
                                        for (String p : m.getPathSpecs()) {
                                            matches |= Objects.equals(p, key);
                                        }
                                        if (matches) continue;
                                        if (nnew < newm.length) {
                                            newm[nnew] = m;
                                        }
                                        ++nnew;
                                    }
                                    if (nnew == newm.length) {
                                        if (log.isDebugEnabled()) {
                                            log.debug("New mappings after removal of [{}] are {}", key, (Object)Arrays.toString(newm));
                                        }
                                        h.setServletMappings((ServletMapping[])newm);
                                    } else {
                                        log.warn("Cannot find a mapping for [{}] to remove.", key);
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error("Error stopping servlet holder for path [{}]", key, (Object)e);
                            }
                        }
                    }
                });
                this.server = jettyServer;
                componentManager.commit();
            }
            catch (Throwable e) {
                throw new RuntimeException("Error setting up Jetty Server: " + e.getMessage(), e);
            }
        });
    }

    public void stop(ServiceContext svcCtxt) throws Exception {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Throwable e) {
                log.error("Error stopping Jetty Server", e);
            }
            this.server = null;
        }
        if (this.servletRegistration != null) {
            try {
                this.servletRegistration.close();
            }
            catch (Throwable e) {
                log.error("Error cancelling listener for Servlet instances.", e);
            }
            this.servletRegistration = null;
            this.servlets.clear();
        }
    }
}

