/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.svc.api.ConfigWrapper;
import org.clazzes.svc.api.monitoring.AsyncMetrics;
import org.clazzes.svc.api.monitoring.HealthCheck;
import org.clazzes.svc.api.monitoring.HealthInfo;
import org.clazzes.svc.api.monitoring.HealthStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcHealthCheck
implements HealthCheck,
AsyncMetrics {
    private static final Logger log = LoggerFactory.getLogger(JdbcHealthCheck.class);
    private final String name;
    private final String displayName;
    private final List<String> tags;
    private final HikariDataSource dataSource;
    private final String healthQuery;
    private final long intervalSeconds;

    public JdbcHealthCheck(String name, String displayName, List<String> tags, HikariDataSource dataSource, String healthQuery, long intervalSeconds) {
        this.name = name;
        this.displayName = displayName;
        this.tags = tags;
        this.dataSource = dataSource;
        this.healthQuery = healthQuery;
        this.intervalSeconds = intervalSeconds;
    }

    private static List<String> getHealthTags(ConfigWrapper config) {
        List healthTags = config.getStringList("healthTags");
        if (healthTags == null) {
            return null;
        }
        if (healthTags.contains("jdbc")) {
            return healthTags;
        }
        ArrayList<String> ret = new ArrayList<String>(healthTags.size() + 1);
        ret.add("jdbc");
        ret.addAll(healthTags);
        return ret;
    }

    public static JdbcHealthCheck ofConfig(String name, HikariDataSource dataSource, ConfigWrapper config) {
        List<String> healthTags = JdbcHealthCheck.getHealthTags(config);
        if (healthTags == null) {
            return null;
        }
        String healthQuery = config.getString("healthQuery");
        long healthInterval = config.getLong("healthInterval", 10L);
        boolean healthShowUrl = config.getBoolean("healthShowUrl", false);
        Object displayName = healthShowUrl ? name + "|" + dataSource.getJdbcUrl() : name;
        return new JdbcHealthCheck(name, (String)displayName, healthTags, dataSource, healthQuery, healthInterval);
    }

    public String getDescription() {
        return "Check database " + this.name + " using query [" + this.healthQuery + "].";
    }

    public String getId() {
        return "jdbc." + this.name;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public long getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public HealthInfo call() throws Exception {
        try (Connection conn = this.dataSource.getConnection();){
            String queryResult;
            block29: {
                if (this.healthQuery == null) {
                    HealthInfo healthInfo = new HealthInfo(HealthStatus.OK, "Datasource [" + this.displayName + "] is OK as per validationQuery.");
                    return healthInfo;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Performing healthQuery [{}] for datasource [{}]...", (Object)this.healthQuery, (Object)this.name);
                }
                Statement stmt = conn.createStatement();
                ResultSet res = stmt.executeQuery(this.healthQuery);
                if (res.next()) {
                    queryResult = res.getString(1);
                    if (res.next()) {
                        log.warn("More than one result performing healthQuery [{}] for datasource [{}], first result was [{}]", new Object[]{this.healthQuery, this.name, queryResult});
                        HealthInfo healthInfo = new HealthInfo(HealthStatus.HEALTH_CHECK_ERROR, "Datasource [" + this.displayName + "] returned more than one result for healthQuery, first result was [" + queryResult + "].");
                        return healthInfo;
                    }
                    break block29;
                }
                log.warn("No result performing healthQuery [{}] for datasource [{}]", (Object)this.healthQuery, (Object)this.name);
                HealthInfo healthInfo = new HealthInfo(HealthStatus.HEALTH_CHECK_ERROR, "Datasource [" + this.displayName + "] returned no result for healthQuery.");
                return healthInfo;
                {
                    finally {
                        if (res != null) {
                            res.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("healthQuery [{}] for datasource [{}] returned [{}].", new Object[]{this.healthQuery, this.name, queryResult});
            }
            HealthInfo healthInfo = new HealthInfo(HealthStatus.OK, "Check for datasource [" + this.displayName + "] returned [" + queryResult + "].");
            return healthInfo;
        }
    }

    public String toString() {
        return "JdbcHealthCheck [name=" + this.name + ", tags=" + String.valueOf(this.tags) + ", healthQuery=" + this.healthQuery + ", intervalSeconds=" + this.intervalSeconds + "]";
    }
}

