/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ConfigWrapper;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.CoreService;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServicePriority;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.svc.api.monitoring.HealthCheck;
import org.clazzes.svc.runner.jdbc.DataSourceHelper;
import org.clazzes.svc.runner.jdbc.DataSourceRecord;
import org.clazzes.svc.runner.jdbc.JdbcHealthCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServicePriority(value=10)
public class JdbcComponent
implements Component {
    private static final Logger log = LoggerFactory.getLogger(JdbcComponent.class);
    private static final String PID = "org.clazzes.jdbc.provider";
    private static final long[] START_INTERVALS = new long[]{5L, 10L, 15L, 30L, 60L};
    private SortedMap<String, DataSourceRecord> dataSources;
    private SortedMap<String, Future<?>> startJobFutures;
    private int nConfiguredDataSources;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean activateDataSource(ServiceRegistry registry, ComponentManager componentManager, String key, HikariDataSource ds, JdbcHealthCheck healthCheck, ConfigWrapper dsConfig) throws InterruptedException {
        log.info("Activating datasource [{}] with URL [{}].", (Object)key, (Object)ds.getJdbcUrl());
        Connection connection = null;
        try {
            boolean doCommit;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            connection = ds.getConnection();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            DatabaseMetaData md = connection.getMetaData();
            log.info("Connected datasource [{}] to [{}], version [{}] using driver [{}], version [{}].", new Object[]{key, md.getDatabaseProductName(), md.getDatabaseProductVersion(), md.getDriverName(), md.getDriverVersion()});
            JdbcComponent jdbcComponent = this;
            synchronized (jdbcComponent) {
                this.dataSources.put(key, new DataSourceRecord(ds, healthCheck, dsConfig));
                this.startJobFutures.remove(key);
                registry.addService(key, DataSource.class, (Object)ds);
                if (healthCheck != null) {
                    registry.addService(healthCheck.getId(), HealthCheck.class, (Object)healthCheck);
                }
                log.info("Successfully activated JDBC datasource [{}] no. [{}/{}].", new Object[]{key, this.dataSources.size(), this.nConfiguredDataSources});
                doCommit = this.dataSources.size() == this.nConfiguredDataSources;
            }
            if (doCommit) {
                componentManager.commit();
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            log.error("Activating datasource [{}] failed", (Object)key, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.warn("Error returning probe connection to pool for datasource [" + key + "]", (Throwable)e);
                }
            }
        }
    }

    private void closeDataSource(ServiceRegistry registry, String key) {
        registry.removeService(key, DataSource.class);
        DataSourceRecord dr = (DataSourceRecord)this.dataSources.get(key);
        if (dr.getHealthCheck() != null) {
            registry.removeService(dr.getHealthCheck().getId(), HealthCheck.class);
        }
        log.info("Closing JDBC datasource [{}]...", (Object)key);
        try {
            dr.getDataSource().close();
            log.info("Successfully closed JDBC datasource [{}].", (Object)key);
        }
        catch (Throwable e) {
            log.error("Error closing JDBC datasource [{}].", (Object)key, (Object)e);
        }
    }

    private void closeDataSources(ServiceRegistry registry) {
        if (this.startJobFutures != null) {
            for (Map.Entry entry : this.startJobFutures.entrySet()) {
                log.info("Cancelling start job for datasource [{}]", entry.getKey());
                ((Future)entry.getValue()).cancel(true);
            }
        }
        if (this.dataSources != null) {
            for (String string : this.dataSources.keySet()) {
                this.closeDataSource(registry, string);
            }
        }
    }

    public void start(ServiceContext svcCtxt) throws Exception {
        ServiceRegistry registry = (ServiceRegistry)svcCtxt.getService(ServiceRegistry.class).get();
        ConfigurationEngine configurationEngine = (ConfigurationEngine)svcCtxt.getService(ConfigurationEngine.class).get();
        CoreService cs = (CoreService)svcCtxt.getService(CoreService.class).get();
        ComponentManager componentManager = (ComponentManager)svcCtxt.getService(ComponentManager.class).get();
        ScheduledExecutorService scheduledExecutorService = cs.getScheduledExecutorService();
        configurationEngine.listen(PID, config -> {
            ConfigWrapper datasources = config.getSubTree("datasource");
            JdbcComponent jdbcComponent = this;
            synchronized (jdbcComponent) {
                this.closeDataSources(registry);
                this.dataSources = new TreeMap<String, DataSourceRecord>();
                this.startJobFutures = new TreeMap();
                this.nConfiguredDataSources = datasources.keySet().size();
            }
            for (String key : datasources.keySet()) {
                ConfigWrapper dsConfig = datasources.getSubTree(key);
                log.info("Creating JDBC datasource [{}]...", (Object)key);
                try {
                    HikariDataSource ds = DataSourceHelper.createDataSource(dsConfig);
                    JdbcHealthCheck healthCheck = JdbcHealthCheck.ofConfig(key, ds, dsConfig);
                    log.info("Successfully created JDBC datasource [{}] with health check [{}].", (Object)key, (Object)healthCheck);
                    if (this.activateDataSource(registry, componentManager, key, ds, healthCheck, dsConfig)) continue;
                    long secs = START_INTERVALS[0];
                    log.info("Unable to connect JDBC datasource [{}] at first glance, retrying in [{}s].", (Object)key, (Object)secs);
                    ScheduledFuture<?> future = scheduledExecutorService.schedule(new StartDataSourceRunnable(key, ds, healthCheck, dsConfig, registry, componentManager, scheduledExecutorService), START_INTERVALS[0], TimeUnit.SECONDS);
                    JdbcComponent jdbcComponent2 = this;
                    synchronized (jdbcComponent2) {
                        this.startJobFutures.put(key, future);
                    }
                }
                catch (Throwable e) {
                    log.error("Error creating JDBC datasource [{}].", (Object)key, (Object)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ServiceContext svcCtxt) throws Exception {
        ServiceRegistry registry = (ServiceRegistry)svcCtxt.getService(ServiceRegistry.class).get();
        JdbcComponent jdbcComponent = this;
        synchronized (jdbcComponent) {
            this.closeDataSources(registry);
            this.dataSources = null;
            this.startJobFutures = null;
            this.nConfiguredDataSources = 0;
        }
    }

    static {
        ServiceLoader<Driver> loader = ServiceLoader.load(JdbcComponent.class.getModule().getLayer(), Driver.class);
        for (Driver driver : loader) {
            log.info("Registering JDBC driver [{}].", (Object)driver.getClass().getName());
            try {
                DriverManager.registerDriver(driver);
            }
            catch (SQLException e) {
                log.error("Failed to register JDBC driver [{}]", (Object)driver.getClass().getName(), (Object)e);
            }
        }
    }

    private class StartDataSourceRunnable
    implements Runnable {
        private final String key;
        private final HikariDataSource dataSource;
        private final JdbcHealthCheck healthCheck;
        private final ConfigWrapper dsConfig;
        private final ServiceRegistry registry;
        private final ComponentManager componentManager;
        private final ScheduledExecutorService scheduledExecutorService;
        private int ntry;

        public StartDataSourceRunnable(String key, HikariDataSource dataSource, JdbcHealthCheck healthCheck, ConfigWrapper dsConfig, ServiceRegistry registry, ComponentManager componentManager, ScheduledExecutorService scheduledExecutorService) {
            this.key = key;
            this.dataSource = dataSource;
            this.healthCheck = healthCheck;
            this.dsConfig = dsConfig;
            this.registry = registry;
            this.componentManager = componentManager;
            this.scheduledExecutorService = scheduledExecutorService;
            this.ntry = 0;
        }

        private long getNextExecutionDelay() {
            if (this.ntry >= START_INTERVALS.length) {
                return START_INTERVALS[START_INTERVALS.length - 1];
            }
            return START_INTERVALS[this.ntry];
        }

        @Override
        public void run() {
            try {
                ++this.ntry;
                log.error("Retry no. [{}] to connect to database [{}].", (Object)this.ntry, (Object)this.key);
                if (!JdbcComponent.this.activateDataSource(this.registry, this.componentManager, this.key, this.dataSource, this.healthCheck, this.dsConfig)) {
                    this.scheduledExecutorService.schedule(this, this.getNextExecutionDelay(), TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException e) {
                log.error("Retry no. [{}] to connect to database [{}] has been interrupted.", new Object[]{this.ntry, this.key, e});
            }
        }
    }
}

