/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import org.clazzes.svc.api.ConfigWrapper;

public abstract class DataSourceHelper {
    static HikariDataSource createDataSource(ConfigWrapper config) throws SQLException {
        String defaultTransactionIsolation;
        Boolean defaultAutoCommit;
        Boolean defaultReadOnly;
        String defaultSchema;
        String defaultCatalog;
        Integer loginTimeout;
        Long validationTimeout;
        Long connectionTimeout;
        Long idleTimeout;
        Integer minIdle;
        Integer maxTotal;
        Long maxConnLifetimeMillis;
        String validationQuery;
        String passwd;
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(config.getMandatoryString("url"));
        String username = config.getString("username");
        if (username != null) {
            ds.setUsername(username);
        }
        if ((passwd = config.getString("password")) != null) {
            ds.setPassword(passwd);
        }
        if ((validationQuery = config.getString("validationQuery")) != null) {
            ds.setConnectionTestQuery(validationQuery);
        }
        if ((maxConnLifetimeMillis = config.getLong("maxConnLifetimeMillis")) != null) {
            ds.setMaxLifetime(maxConnLifetimeMillis.longValue());
        }
        if ((maxTotal = config.getInteger("maxTotal")) != null) {
            ds.setMaximumPoolSize(maxTotal.intValue());
        }
        if ((minIdle = config.getInteger("minIdle")) != null) {
            ds.setMinimumIdle(minIdle.intValue());
        }
        if ((idleTimeout = config.getLong("idleTimeout")) != null) {
            ds.setIdleTimeout(idleTimeout.longValue());
        }
        if ((connectionTimeout = config.getLong("connectionTimeout")) != null) {
            ds.setConnectionTimeout(connectionTimeout.longValue());
        }
        if ((validationTimeout = config.getLong("validationTimeout")) != null) {
            ds.setValidationTimeout(validationTimeout.longValue());
        }
        if ((loginTimeout = config.getInteger("loginTimeout")) != null) {
            ds.setLoginTimeout(loginTimeout.intValue());
        }
        if ((defaultCatalog = config.getString("defaultCatalog")) != null) {
            ds.setCatalog(defaultCatalog);
        }
        if ((defaultSchema = config.getString("defaultSchema")) != null) {
            ds.setSchema(defaultSchema);
        }
        if ((defaultReadOnly = config.getBoolean("defaultReadOnly")) != null) {
            ds.setReadOnly(defaultReadOnly.booleanValue());
        }
        if ((defaultAutoCommit = config.getBoolean("defaultAutoCommit")) != null) {
            ds.setAutoCommit(defaultAutoCommit.booleanValue());
        }
        if ((defaultTransactionIsolation = config.getString("defaultTransactionIsolation")) != null) {
            ds.setTransactionIsolation(defaultTransactionIsolation);
        }
        return ds;
    }
}

