/***********************************************************
*
* Service Runner of the clazzes.org project
* https://www.clazzes.org
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
***********************************************************/

package org.clazzes.svc.runner.jdbc;

import org.clazzes.svc.api.ConfigWrapper;

import com.zaxxer.hikari.HikariDataSource;

/**
 * A configured data source.
 */
public final class DataSourceRecord {

    private final HikariDataSource dataSource;
    private final JdbcHealthCheck healthCheck;
    private final ConfigWrapper configProps;

    public DataSourceRecord(HikariDataSource dataSource,
                            JdbcHealthCheck healthCheck,
                            ConfigWrapper configProps) {
        super();
        this.dataSource = dataSource;
        this.healthCheck = healthCheck;
        this.configProps = configProps;
    }

    /**
     * @return The datasource instantiated with the given configuration
     *         properties.
     */
    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    /**
     * @return The unmodifiable configuration properties of this data source.
     */
    public ConfigWrapper getConfigProps() {
        return this.configProps;
    }

    /**
     *
     * @return The configured helath check or <code>null</code>, if no health
     *         check is configured.
     */
    public JdbcHealthCheck getHealthCheck() {
        return this.healthCheck;
    }
}
