/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.jdbc.cmd;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.clazzes.svc.api.CoreService;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.svc.api.cmd.Argument;
import org.clazzes.svc.api.cmd.CommandSet;
import org.clazzes.svc.api.cmd.Descriptor;
import org.clazzes.svc.api.cmd.Parameter;
import org.clazzes.svc.runner.jdbc.cmd.DataSourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCommands
implements CommandSet {
    private static final Logger log = LoggerFactory.getLogger(JdbcCommands.class);
    public static final List<String> COMMANDS = List.of("connect", "connection", "desc", "dump", "lsc", "query", "showtables", "sql");
    private static final String[] DEFAULT_SHOWTABLE_RESULT_COLUMNS = new String[]{"TABLE_NAME", "TABLE_TYPE", "TABLE_CAT", "TABLE_SCHEM"};
    private static final String[] DEFAULT_DESC_RESULT_COLUMNS = new String[]{"COLUMN_NAME", "TYPE_NAME", "COLUMN_SIZE", "DECIMAL_DIGITS", "NULLABLE"};
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String NULL_STRING = "\u00a0";
    private static final Pattern SECRET_PATTERN = Pattern.compile("^secret::(env|prop|void):(.*)$");
    private final CoreService coreService;
    private final ServiceRegistry serviceRegistry;
    private static final Set<Integer> YAML_SPECIALS = ":{}[],&*#?|-<>=!%@\\".chars().boxed().collect(Collectors.toSet());

    public JdbcCommands(CoreService coreService, ServiceRegistry serviceRegistry) {
        this.coreService = coreService;
        this.serviceRegistry = serviceRegistry;
    }

    public List<String> getCommands() {
        return COMMANDS;
    }

    @Descriptor(value="List registered JDBC connections.")
    public void lsc(PrintStream out) throws Exception {
        Map datasources = this.serviceRegistry.getAll(DataSource.class);
        out.println("Registered Datasources:");
        if (datasources == null || datasources.isEmpty()) {
            out.println("  No datasources found.");
        } else {
            for (String name : datasources.keySet()) {
                if (name == null) continue;
                out.println("  " + name);
            }
        }
    }

    protected static final void printDatabaseMetaData(PrintStream out, String datasourceName, Connection conn) throws SQLException {
        DatabaseMetaData md = conn.getMetaData();
        out.println("Datasource [" + datasourceName + "] properties:");
        out.println("  JDBC URL:        " + md.getURL());
        out.println("  Product Name:    " + md.getDatabaseProductName());
        out.println("  Product Version: " + md.getDatabaseProductVersion());
        out.println("  Driver Name:     " + md.getDriverName());
        out.println("  Driver Version:  " + md.getDriverVersion());
        out.println("  QuoteString:     " + md.getIdentifierQuoteString());
    }

    @Descriptor(value="Show connection informations.")
    public void connection(PrintStream out, @Descriptor(value="datasource name") String datasourceName) throws Exception {
        try (DataSourceContext ctx = new DataSourceContext(this.serviceRegistry, datasourceName);
             Connection conn = ctx.getDataSource().getConnection();){
            JdbcCommands.printDatabaseMetaData(out, datasourceName, conn);
        }
    }

    @Descriptor(value="Connect to a database by URL, username and password.")
    public void connect(PrintStream out, @Descriptor(value="JDBC URL") String url, @Descriptor(value="Connection properties like user=myuser or password=secret::env:MY_PASS") String[] props) throws Exception {
        Object v;
        Properties properties = new Properties(props.length);
        HashMap<String, AbstractMap.SimpleImmutableEntry<String, String>> secrets = new HashMap<String, AbstractMap.SimpleImmutableEntry<String, String>>(props.length);
        for (String prop : props) {
            String[] kv = prop.strip().split(" *= *", 2);
            String k = kv[0];
            if (kv.length < 2) {
                v = null;
                out.println("WARNING: key [" + k + "] given without value, assuming null.");
            } else {
                v = kv[1];
                Matcher m = SECRET_PATTERN.matcher((CharSequence)v);
                if (m.matches()) {
                    String scheme = m.group(1);
                    String key = m.group(2);
                    secrets.put(k, new AbstractMap.SimpleImmutableEntry<String, String>(scheme, key));
                    v = this.coreService.getSecret("org.clazzes.jdbc.provider", scheme, key);
                }
            }
            properties.put(k, v);
        }
        boolean oracle = url.startsWith("jdbc:oracle:");
        out.println("Connecting to database [" + url + "]...");
        try (Connection conn = DriverManager.getConnection(url, properties);){
            JdbcCommands.printDatabaseMetaData(out, url, conn);
            out.println("YAML configuration will be:");
            out.println("database:");
            out.println("  DBNAME:");
            out.println("      url: " + JdbcCommands.maybeQuoteYaml(url));
            out.println("      validationQuery: " + (oracle ? "select 1 from dual" : "select 1"));
            for (Object k : properties.keySet()) {
                String yamlKey;
                Map.Entry secret = (Map.Entry)secrets.get(k);
                String string = yamlKey = "user".equals(k) ? "username" : k.toString();
                if (secret == null) {
                    v = properties.get(k);
                    out.println("      " + yamlKey + ": " + JdbcCommands.maybeQuoteYaml(v.toString()));
                    continue;
                }
                out.println("      " + yamlKey + ":");
                out.println("        service.type: secret");
                out.println("        scheme: " + (String)secret.getKey());
                out.println("        key: " + JdbcCommands.maybeQuoteYaml((String)secret.getValue()));
            }
        }
    }

    private static final void appendHexByte(StringBuilder sb, byte b) {
        sb.append(HEX_DIGITS[b >> 4 & 0xF]);
        sb.append(HEX_DIGITS[b & 0xF]);
    }

    private static final String formatValue(ResultSetMetaData md, ResultSet rs, int idx, int maxWidth) throws SQLException {
        String o = null;
        int type = md.getColumnType(idx);
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                o = rs.getString(idx);
                break;
            }
            case -3: 
            case -2: {
                byte[] b = rs.getBytes(idx);
                if (b == null) break;
                if (b.length == 0) {
                    o = "";
                    break;
                }
                int nbytes = (maxWidth - 2) / 2;
                StringBuilder sb = new StringBuilder(maxWidth);
                sb.append("0x");
                for (int i = 0; i < b.length && i < nbytes; ++i) {
                    JdbcCommands.appendHexByte(sb, b[i]);
                }
                o = sb.toString();
                break;
            }
            case -4: 
            case 2004: {
                Blob blob = rs.getBlob(idx);
                if (blob == null) break;
                int nbytes = (maxWidth - 2) / 2;
                if (blob.length() < (long)nbytes) {
                    nbytes = (int)blob.length();
                }
                if (nbytes <= 0) {
                    o = "";
                    break;
                }
                StringBuilder sb = new StringBuilder(maxWidth);
                sb.append("0x");
                byte[] b = blob.getBytes(0L, nbytes);
                for (int i = 0; i < b.length && i < nbytes; ++i) {
                    JdbcCommands.appendHexByte(sb, b[i]);
                }
                o = sb.toString();
                break;
            }
            case 2005: {
                Clob clob = rs.getClob(idx);
                if (clob == null) break;
                int nchars = maxWidth;
                if (clob.length() < (long)nchars) {
                    nchars = (int)clob.length();
                }
                o = clob.getSubString(0L, nchars);
                break;
            }
            case 2011: {
                NClob nclob = rs.getNClob(idx);
                if (nclob == null) break;
                int nchars = maxWidth;
                if (nclob.length() < (long)nchars) {
                    nchars = (int)nclob.length();
                }
                o = nclob.getSubString(0L, nchars);
                break;
            }
            default: {
                o = String.format(Locale.ENGLISH, "<unknown type %d>", type);
            }
        }
        return o;
    }

    private static final void printRawValue(PrintStream out, Charset cs, ResultSetMetaData md, ResultSet rs, int i) throws SQLException, IOException {
        int type = md.getColumnType(i + 1);
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                String s = rs.getString(i + 1);
                if (s == null) {
                    out.write(0);
                    break;
                }
                out.write(rs.getString(i + 1).getBytes(cs));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] b = rs.getBytes(i + 1);
                if (b == null) {
                    out.write(0);
                    break;
                }
                out.write(b);
                break;
            }
            case 2004: {
                Blob blob = rs.getBlob(i + 1);
                if (blob == null) {
                    out.write(0);
                    break;
                }
                try (InputStream is = blob.getBinaryStream();){
                    int n;
                    byte[] buf = new byte[16384];
                    while ((n = is.read(buf)) > 0) {
                        out.write(buf, 0, n);
                    }
                    break;
                }
            }
            case 2005: 
            case 2011: {
                Clob clob = rs.getClob(i + 1);
                if (clob == null) {
                    out.write(0);
                    break;
                }
                try (Reader reader = clob.getCharacterStream();){
                    int n;
                    CharsetEncoder enc = cs.newEncoder();
                    CharBuffer buf = CharBuffer.allocate(8192);
                    ByteBuffer bbuf = ByteBuffer.allocate(16384);
                    while ((n = reader.read(buf.array(), buf.position(), buf.remaining())) > 0) {
                        buf.limit(buf.position() + n);
                        buf.position(0);
                        enc.encode(buf, bbuf, false);
                        out.write(bbuf.array(), 0, bbuf.position());
                        bbuf.position(0);
                        buf.compact();
                    }
                    if (buf.position() <= 0) break;
                    buf.limit(buf.position());
                    buf.position(0);
                    enc.encode(buf, bbuf, true);
                    out.write(bbuf.array(), 0, bbuf.position());
                    bbuf.position(0);
                    break;
                }
            }
            default: {
                out.write(String.format(Locale.ENGLISH, "<unknown type %d>", type).getBytes(cs));
            }
        }
    }

    private static final String quoteCsv(String v) {
        StringBuilder sb = new StringBuilder(v.length() * 2);
        sb.append('\"');
        int i = 0;
        while (i < v.length()) {
            int cp = v.codePointAt(i);
            if (cp == 34) {
                sb.append("\"\"");
            } else {
                sb.appendCodePoint(cp);
            }
            i = v.offsetByCodePoints(i, 1);
        }
        sb.append('\"');
        return sb.toString();
    }

    private static final String maybeQuoteCsv(String v) {
        if (v == null) {
            return "";
        }
        if (v.isEmpty()) {
            return "\"\"";
        }
        int i = 0;
        while (i < v.length()) {
            int cp = v.codePointAt(i);
            if (cp == 34 || cp == 44 || cp == 10 || cp == 13) {
                return JdbcCommands.quoteCsv(v);
            }
            i = v.offsetByCodePoints(i, 1);
        }
        return v;
    }

    private static final String quoteYaml(String v) {
        StringBuilder sb = new StringBuilder(v.length() * 2);
        sb.append('\"');
        int i = 0;
        while (i < v.length()) {
            int cp = v.codePointAt(i);
            if (cp == 34 || cp == 92) {
                sb.append('\\');
            }
            sb.appendCodePoint(cp);
            i = v.offsetByCodePoints(i, 1);
        }
        sb.append('\"');
        return sb.toString();
    }

    private static final String maybeQuoteYaml(String v) {
        if (v == null) {
            return "";
        }
        if (v.isEmpty()) {
            return "\"\"";
        }
        int i = 0;
        while (i < v.length()) {
            int cp = v.codePointAt(i);
            if (YAML_SPECIALS.contains(cp)) {
                return JdbcCommands.quoteYaml(v);
            }
            i = v.offsetByCodePoints(i, 1);
        }
        return v;
    }

    private static void printResultSetCsv(PrintStream out, ResultSet rs, int maxWidth) throws SQLException {
        int i;
        ResultSetMetaData md = rs.getMetaData();
        int n = md.getColumnCount();
        StringBuilder line = new StringBuilder(16384);
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                line.append(',');
            }
            line.append(JdbcCommands.maybeQuoteCsv(md.getColumnName(i + 1)));
        }
        out.println(line.toString());
        while (rs.next()) {
            line.setLength(0);
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    line.append(',');
                }
                String o = JdbcCommands.formatValue(md, rs, i + 1, maxWidth);
                line.append(JdbcCommands.maybeQuoteCsv(o));
            }
            out.println(line.toString());
        }
    }

    private static void printResultSetRaw(PrintStream out, ResultSet rs, String encoding) throws SQLException, IOException {
        Charset cs = Charset.forName(encoding);
        ResultSetMetaData md = rs.getMetaData();
        int n = md.getColumnCount();
        int irow = 0;
        while (rs.next()) {
            if (irow > 0) {
                out.write(30);
            }
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    out.write(31);
                }
                JdbcCommands.printRawValue(out, cs, md, rs, i);
            }
            ++irow;
        }
    }

    private static final String pad(String o, int width) {
        String v;
        String string = v = o == null ? "null" : o;
        if (v.length() == width) {
            return v;
        }
        if (v.length() > width) {
            return v.substring(0, width - 1) + "\u2026";
        }
        StringBuilder sb = new StringBuilder(width);
        sb.append(v);
        while (sb.length() < width) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private static void printResultSet(PrintStream out, ResultSet rs, int maxWidth, String[] columns) throws SQLException {
        int i;
        int i2;
        int[] indices;
        ResultSetMetaData md = rs.getMetaData();
        int n = md.getColumnCount();
        int[] widths = new int[n];
        if (columns == null) {
            indices = new int[n];
            for (int i3 = 0; i3 < n; ++i3) {
                indices[i3] = i3 + 1;
            }
        } else {
            indices = new int[columns.length];
            HashMap<String, Integer> nameColumns = new HashMap<String, Integer>();
            for (i2 = 0; i2 < n; ++i2) {
                nameColumns.put(md.getColumnName(i2 + 1), i2 + 1);
            }
            n = 0;
            for (i2 = 0; i2 < columns.length; ++i2) {
                Integer idx = (Integer)nameColumns.get(columns[i2]);
                if (idx == null) {
                    log.warn("Column [{}] not found in result column list [{}]", (Object)columns[i2], nameColumns.keySet());
                    continue;
                }
                indices[n++] = idx;
            }
        }
        int nall = 1;
        for (i2 = 0; i2 < n; ++i2) {
            int type = md.getColumnType(indices[i2]);
            switch (type) {
                case -15: 
                case -9: 
                case 1: 
                case 12: 
                case 91: 
                case 92: 
                case 93: {
                    widths[i2] = md.getPrecision(indices[i2]);
                    break;
                }
                case 2: 
                case 3: {
                    widths[i2] = md.getPrecision(indices[i2]) + 1;
                    break;
                }
                case -7: 
                case -6: 
                case 5: 
                case 16: {
                    widths[i2] = 6;
                    break;
                }
                case 4: {
                    widths[i2] = 10;
                    break;
                }
                case -5: 
                case 6: 
                case 8: {
                    widths[i2] = 20;
                    break;
                }
                default: {
                    widths[i2] = maxWidth;
                }
            }
            int l = md.getColumnName(indices[i2]).length();
            if (l > widths[i2]) {
                widths[i2] = l;
            }
            if (widths[i2] > maxWidth) {
                widths[i2] = maxWidth;
            }
            nall += widths[i2];
            ++nall;
            if (!log.isDebugEnabled()) continue;
            log.debug("Column {}: type={}, width={}", new Object[]{indices[i2], type, widths[i2]});
        }
        StringBuilder line = new StringBuilder(nall);
        line.setLength(0);
        line.append('|');
        for (i = 0; i < n; ++i) {
            line.append(JdbcCommands.pad(md.getColumnName(indices[i]), widths[i]));
            line.append('|');
        }
        out.println(line.toString());
        line.setLength(0);
        line.append('+');
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < widths[i]; ++j) {
                line.append('-');
            }
            line.append('+');
        }
        out.println(line.toString());
        int nlines = 0;
        while (rs.next()) {
            line.setLength(0);
            line.append('|');
            for (int i4 = 0; i4 < n; ++i4) {
                String o = JdbcCommands.formatValue(md, rs, indices[i4], maxWidth + 2);
                line.append(JdbcCommands.pad(o, widths[i4]));
                line.append('|');
            }
            out.println(line.toString());
            ++nlines;
        }
        switch (nlines) {
            case 0: {
                out.println("No results");
                break;
            }
            case 1: {
                out.println("1 result");
                break;
            }
            default: {
                out.println(String.format(Locale.ENGLISH, "%d results", nlines));
            }
        }
    }

    @Descriptor(value="Show all database tables.")
    public void showtables(PrintStream out, @Descriptor(value="Database catalog to search") @Parameter(names={"-C", "--catalog"}, absentValue="\u00a0") String catalog, @Descriptor(value="Database Schema pattern") @Parameter(names={"-s", "--schema"}, absentValue="\u00a0") String schemaPattern, @Descriptor(value="Table Name pattern") @Parameter(names={"-t", "--table"}, absentValue="\u00a0") String tableNamePattern, @Descriptor(value="Maximal output length of column data") @Parameter(names={"-l", "--length"}, absentValue="32") int outputLength, @Descriptor(value="Verbose output in normal output (print all JDBC columns)") @Parameter(names={"-v", "--verbose"}, presentValue="true", absentValue="false") boolean verbose, @Descriptor(value="Output in CSV format") @Parameter(names={"-c", "--csv"}, presentValue="true", absentValue="false") boolean csv, @Descriptor(value="Output in raw binary format") @Parameter(names={"-r", "--raw"}, presentValue="true", absentValue="false") boolean raw, @Descriptor(value="Encoding of raw output") @Parameter(names={"-e", "--encoding"}, absentValue="UTF-8") String encoding, @Descriptor(value="Name of the registered datasource") @Argument(value="datasource") String datasourceName) throws Exception {
        if (NULL_STRING.equals(catalog)) {
            catalog = null;
        }
        if (NULL_STRING.equals(schemaPattern)) {
            schemaPattern = null;
        }
        if (NULL_STRING.equals(tableNamePattern)) {
            tableNamePattern = null;
        }
        try (DataSourceContext ctx = new DataSourceContext(this.serviceRegistry, datasourceName);
             Connection conn = ctx.getDataSource().getConnection();){
            DatabaseMetaData md = conn.getMetaData();
            try (ResultSet rs = md.getTables(catalog, schemaPattern, tableNamePattern, null);){
                if (csv) {
                    JdbcCommands.printResultSetCsv(out, rs, outputLength);
                } else if (raw) {
                    JdbcCommands.printResultSetRaw(out, rs, encoding);
                } else {
                    JdbcCommands.printResultSet(out, rs, outputLength, verbose ? null : DEFAULT_SHOWTABLE_RESULT_COLUMNS);
                }
            }
        }
    }

    @Descriptor(value="Describe a database table.")
    public void desc(PrintStream out, @Descriptor(value="Database catalog to search") @Parameter(names={"-C", "--catalog"}, absentValue="\u00a0") String catalog, @Descriptor(value="Database Schema pattern") @Parameter(names={"-s", "--schema"}, absentValue="\u00a0") String schemaPattern, @Descriptor(value="Maximal output length of column data") @Parameter(names={"-l", "--length"}, absentValue="32") int outputLength, @Descriptor(value="Verbose output in normal output (print all JDBC columns)") @Parameter(names={"-v", "--verbose"}, presentValue="true", absentValue="false") boolean verbose, @Descriptor(value="Output in CSV format") @Parameter(names={"-c", "--csv"}, presentValue="true", absentValue="false") boolean csv, @Descriptor(value="Output in raw binary format") @Parameter(names={"-r", "--raw"}, presentValue="true", absentValue="false") boolean raw, @Descriptor(value="Encoding of raw output") @Parameter(names={"-e", "--encoding"}, absentValue="UTF-8") String encoding, @Descriptor(value="Name of the registered datasource") @Argument(value="datasource") String datasourceName, @Descriptor(value="Table Name to descibe") @Argument(value="table") String tableName) throws Exception {
        if (NULL_STRING.equals(catalog)) {
            catalog = null;
        }
        if (NULL_STRING.equals(schemaPattern)) {
            schemaPattern = null;
        }
        try (DataSourceContext ctx = new DataSourceContext(this.serviceRegistry, datasourceName);
             Connection conn = ctx.getDataSource().getConnection();){
            DatabaseMetaData md = conn.getMetaData();
            try (ResultSet rs = md.getColumns(catalog, schemaPattern, tableName, null);){
                if (csv) {
                    JdbcCommands.printResultSetCsv(out, rs, outputLength);
                } else if (raw) {
                    JdbcCommands.printResultSetRaw(out, rs, encoding);
                } else {
                    JdbcCommands.printResultSet(out, rs, outputLength, verbose ? null : DEFAULT_DESC_RESULT_COLUMNS);
                }
            }
        }
    }

    private static void runQuery(PrintStream out, Statement statement, String sql, int outputLength, boolean csv, boolean raw, String encoding) throws SQLException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("Executing query [{}].", (Object)sql);
        }
        if (statement.execute(sql)) {
            int irs = 0;
            do {
                try (ResultSet rs = statement.getResultSet();){
                    if (csv) {
                        JdbcCommands.printResultSetCsv(out, rs, outputLength);
                    } else if (raw) {
                        if (irs > 0) {
                            out.write(29);
                        }
                        JdbcCommands.printResultSetRaw(out, rs, encoding);
                    } else {
                        JdbcCommands.printResultSet(out, rs, outputLength, null);
                    }
                }
                ++irs;
            } while (statement.getMoreResults());
        } else {
            int n = statement.getUpdateCount();
            if (n == 0) {
                out.println("No row updated.");
            } else if (n == 1) {
                out.println("1 row updated.");
            } else if (n > 1) {
                out.println(String.format(Locale.ENGLISH, "%d rows updated.", n));
            }
        }
    }

    @Descriptor(value="Perform an SQL query.")
    public void query(PrintStream out, @Descriptor(value="Maximal output length of column data") @Parameter(names={"-l", "--length"}, absentValue="32") int outputLength, @Descriptor(value="Maximal number of rows to show") @Parameter(names={"-L", "--limit"}, absentValue="-1") int limit, @Descriptor(value="Output in CSV format") @Parameter(names={"-c", "--csv"}, presentValue="true", absentValue="false") boolean csv, @Descriptor(value="Output in raw binary format") @Parameter(names={"-r", "--raw"}, presentValue="true", absentValue="false") boolean raw, @Descriptor(value="Encoding of raw output") @Parameter(names={"-e", "--encoding"}, absentValue="UTF-8") String encoding, @Descriptor(value="Name of the registered datasource") @Argument(value="datasource") String datasourceName, @Descriptor(value="Query parts") @Argument(value="query") String[] query) throws Exception {
        if (raw && csv) {
            throw new IllegalArgumentException("You must not simulatenously specify -r and -c, choose either CSV or raw output.");
        }
        try (DataSourceContext ctx = new DataSourceContext(this.serviceRegistry, datasourceName);
             Connection conn = ctx.getDataSource().getConnection();
             Statement statement = conn.createStatement();){
            if (limit >= 0) {
                statement.setMaxRows(limit);
            }
            String sql = String.join((CharSequence)" ", query);
            JdbcCommands.runQuery(out, statement, sql, outputLength, csv, raw, encoding);
        }
    }

    @Descriptor(value="Dump a single database table.")
    public void dump(PrintStream out, @Descriptor(value="Maximal output length of column data") @Parameter(names={"-l", "--length"}, absentValue="32") int outputLength, @Descriptor(value="Maximal number of rows to show") @Parameter(names={"-L", "--limit"}, absentValue="-1") int limit, @Descriptor(value="Output in CSV format") @Parameter(names={"-c", "--csv"}, presentValue="true", absentValue="false") boolean csv, @Descriptor(value="Output in raw binary format") @Parameter(names={"-r", "--raw"}, presentValue="true", absentValue="false") boolean raw, @Descriptor(value="Encoding of raw output") @Parameter(names={"-e", "--encoding"}, absentValue="UTF-8") String encoding, @Descriptor(value="Name of the registered datasource") @Argument(value="datasource") String datasourceName, @Descriptor(value="Table name") @Argument(value="table") String tableName) throws Exception {
        if (raw && csv) {
            throw new IllegalArgumentException("You must not simulatenously specify -r and -c, chooe either CSV or raw output.");
        }
        try (DataSourceContext ctx = new DataSourceContext(this.serviceRegistry, datasourceName);
             Connection conn = ctx.getDataSource().getConnection();
             Statement statement = conn.createStatement();){
            if (limit >= 0) {
                statement.setMaxRows(limit);
            }
            DatabaseMetaData md = conn.getMetaData();
            String quote = md.getIdentifierQuoteString();
            String sql = "select * from " + quote + tableName + quote;
            JdbcCommands.runQuery(out, statement, sql, outputLength, csv, raw, encoding);
        }
    }

    @Descriptor(value="Execute SQL queries from stdin.")
    public void sql(PrintStream out, @Descriptor(value="Maximal output length of column data") @Parameter(names={"-l", "--length"}, absentValue="32") int outputLength, @Descriptor(value="Maximal number of rows to show") @Parameter(names={"-L", "--limit"}, absentValue="-1") int limit, @Descriptor(value="Output in CSV format") @Parameter(names={"-c", "--csv"}, presentValue="true", absentValue="false") boolean csv, @Descriptor(value="Output in raw binary format") @Parameter(names={"-r", "--raw"}, presentValue="true", absentValue="false") boolean raw, @Descriptor(value="Encoding of SQL script or raw output") @Parameter(names={"-e", "--encoding"}, absentValue="UTF-8") String encoding, @Descriptor(value="Name of the registered datasource") @Argument(value="datasource") String datasourceName) throws Exception {
        try (DataSourceContext ctx = new DataSourceContext(this.serviceRegistry, datasourceName);
             Connection conn = ctx.getDataSource().getConnection();
             Statement statement = conn.createStatement();
             LineNumberReader reader = new LineNumberReader(new InputStreamReader(System.in, encoding));){
            String trailer;
            if (limit >= 0) {
                statement.setMaxRows(limit);
            }
            StringBuilder sb = new StringBuilder();
            String line = reader.readLine();
            boolean inside_string = false;
            int nquery = 0;
            while (line != null) {
                if (!inside_string && (line.startsWith("--") || line.startsWith("#"))) {
                    line = reader.readLine();
                    continue;
                }
                int i0 = 0;
                int i = 0;
                while (i < line.length()) {
                    int cp = line.codePointAt(i);
                    if (cp == 59 && !inside_string) {
                        sb.append(line.substring(i0, i));
                        String sql = sb.toString().trim();
                        sb.setLength(0);
                        if ("quit".equals(sql)) {
                            return;
                        }
                        if (nquery > 0) {
                            out.println();
                        }
                        ++nquery;
                        if (!raw && !csv) {
                            out.println(sql);
                        }
                        JdbcCommands.runQuery(out, statement, sql, outputLength, csv, raw, encoding);
                        i0 = line.offsetByCodePoints(i, 1);
                    } else if (cp == 39) {
                        inside_string = !inside_string;
                    }
                    i = line.offsetByCodePoints(i, 1);
                }
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(line.substring(i0));
                line = reader.readLine();
            }
            if (sb.length() > 0 && !(trailer = sb.toString().trim()).isEmpty()) {
                if (inside_string) {
                    throw new IllegalArgumentException("Unterminated string in SQL query [" + trailer + "].");
                }
                throw new IllegalArgumentException("Found trailing garbage [" + trailer + "] after last SQL statement.");
            }
        }
    }
}

