/***********************************************************
 *
 * GOGO JDBC commands of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

 package org.clazzes.svc.runner.jdbc.cmd;

import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.CoreService;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServicePriority;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.svc.api.cmd.CommandSet;

@ServicePriority(11)
public class JdbcCmdComponent implements Component {

    @Override
    public void start(ServiceContext svcCtxt) throws Exception {

        CoreService coreService = svcCtxt.getService(CoreService.class).get();
        ServiceRegistry serviceRegistry = svcCtxt.getService(ServiceRegistry.class).get();
        ComponentManager componentManager = svcCtxt.getService(ComponentManager.class).get();

        JdbcCommands jdbcCommands = new JdbcCommands(coreService,serviceRegistry);
        serviceRegistry.addService("jdbc", CommandSet.class,jdbcCommands);

        componentManager.commit();
    }

    @Override
    public void stop(ServiceContext svcCtxt) throws Exception {

        ServiceRegistry serviceRegistry = svcCtxt.getService(ServiceRegistry.class).get();
        serviceRegistry.removeService("jdbc",CommandSet.class);
    }

}
