/***********************************************************
 * $Id$
 *
 * GOGO JDBC commands of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 15. Sep. 2016
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.runner.jdbc.cmd;

import java.util.NoSuchElementException;

import javax.sql.DataSource;

import org.clazzes.svc.api.ServiceRegistry;

/**
 * A context spanned for a given datasource acquired from the bundle context.
 */
public class DataSourceContext implements AutoCloseable {

    private DataSource dataSource;

    /**
     * @throws NoSuchElementException if the given data source name is not registered.
     */
    public DataSourceContext(ServiceRegistry serviceRegistry, String datasourceName) {

        this.dataSource = serviceRegistry.getService(datasourceName,DataSource.class).get();
    }

    /**
     * @return The acquired datasource.
     */
    public DataSource getDataSource() {
        return this.dataSource;
    }

    /* (non-Javadoc)
     * @see java.lang.AutoCloseable#close()
     */
    @Override
    public void close() throws Exception {

        this.dataSource = null;
    }

}
