/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableSubstition {
    private static final int DELIM_START_LEN = 2;
    private static final int DELIM_STOP_LEN = 1;
    private static final Pattern DELIM_START = Pattern.compile("(?<!\\\\)\\$\\{");
    private static final Pattern DELIM_STOP = Pattern.compile("(?<!\\\\)\\}");
    private static final String DOLLAR_REPL = Matcher.quoteReplacement("$");

    private static String substVars(String val, String currentKey, Map<String, String> cycleMap, Function<String, String> accessor) throws IllegalArgumentException {
        cycleMap.put(currentKey, currentKey);
        int stopDelim = -1;
        int startDelim = -1;
        Matcher stopMatcher = DELIM_STOP.matcher((CharSequence)val);
        Matcher startMatcher = DELIM_START.matcher((CharSequence)val);
        do {
            if (!stopMatcher.find()) {
                return val;
            }
            stopDelim = stopMatcher.start();
            if (!startMatcher.find(0)) {
                return val;
            }
            startDelim = startMatcher.start();
            while (startMatcher.find() && startMatcher.start() < stopDelim) {
                startDelim = startMatcher.start();
            }
        } while (startDelim > stopDelim && stopDelim >= 0);
        String variable = ((String)val).substring(startDelim + 2, stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("Recursive reference to variable [" + variable + "].");
        }
        String substValue = accessor.apply(variable);
        if (substValue == null) {
            throw new IllegalArgumentException("Reference to unknown variable [" + variable + "].");
        }
        cycleMap.remove(variable);
        val = ((String)val).substring(0, startDelim) + substValue + ((String)val).substring(stopDelim + 1, ((String)val).length());
        val = VariableSubstition.substVars((String)val, currentKey, cycleMap, accessor);
        return val;
    }

    public static String substVars(String val, String currentKey, Function<String, String> accessor) throws IllegalArgumentException {
        if (val == null) {
            throw new IllegalArgumentException("No value found for key [" + currentKey + "].");
        }
        return VariableSubstition.substVars(val, currentKey, new HashMap<String, String>(), accessor).replaceAll("\\\\\\{", "{").replaceAll("\\\\\\}", "}").replaceAll("\\\\\\$", DOLLAR_REPL).replaceAll("\\\\\\\\", "\\\\");
    }

    public static String substConfigProps(String currentKey, Properties configProps) throws IllegalArgumentException {
        return VariableSubstition.substVars(configProps.getProperty(currentKey), currentKey, k -> {
            String ret = configProps.getProperty((String)k);
            if (ret == null) {
                return System.getProperty(k, "");
            }
            return ret;
        });
    }

    public static String substSystemProperties(String val, String currentKey) throws IllegalArgumentException {
        return VariableSubstition.substVars(val, currentKey, k -> System.getProperty(k, ""));
    }
}

