/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.clazzes.svc.api.ThrowableInfo;
import org.clazzes.svc.runner.Config;
import org.slf4j.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class ThrowableBucket {
    private final int maxSize = Config.getThrowableHistorySize();
    private Deque<ThrowableInfo> throwables;

    public synchronized void addThrowable(ThrowableInfo ti) {
        if (this.throwables == null) {
            this.throwables = new LinkedList<ThrowableInfo>();
        } else if (this.throwables.size() >= this.maxSize) {
            this.throwables.removeLast();
        }
        this.throwables.addFirst(ti);
    }

    public ThrowableInfo error(Logger logger, String msg, Object ... args) {
        FormattingTuple fmt = MessageFormatter.arrayFormat((String)msg, (Object[])args);
        logger.error(fmt.getMessage(), fmt.getThrowable());
        ThrowableInfo ti = new ThrowableInfo(fmt.getMessage(), fmt.getThrowable());
        this.addThrowable(ti);
        return ti;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public synchronized List<ThrowableInfo> getThrowables() {
        return this.throwables == null ? null : new ArrayList<ThrowableInfo>(this.throwables);
    }
}

