/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.clazzes.svc.runner.ConfigurationFiles;

public class ManageConfigs {
    public static void usage() {
        System.err.println("usage:");
        System.err.println("  ManageConfigs -to-yaml <cfg-file> [<cfg-file> ...]");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        String command;
        int iarg = 0;
        if (args.length < 1) {
            ManageConfigs.usage();
        }
        if ("-to-yaml".equals(command = args[iarg++])) {
            if (iarg == args.length) {
                ManageConfigs.usage();
            }
            HashMap configs = new HashMap();
            while (iarg < args.length) {
                Path filename = Path.of(args[iarg], new String[0]);
                Map<String, ?> config = ConfigurationFiles.readCfgFile(filename);
                String pid = ConfigurationFiles.getServicePid(config);
                configs.put(pid, config);
                ++iarg;
            }
            ConfigurationFiles.writeYaml(System.out, "stdout", configs);
        } else {
            System.err.println("Invalid command [" + command + "].");
            ManageConfigs.usage();
        }
    }
}

