/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.clazzes.svc.runner.OpensDirective;

public class LayerConfig {
    public static final String BOOT_LABEL = "$boot";
    private final String label;
    private final Path modulePath;
    private final String parent;
    private final List<OpensDirective> opens;
    private String parentKey;
    private String key;

    protected LayerConfig(String label, Path modulePath, String parent, List<OpensDirective> opens) {
        this.label = label;
        this.modulePath = modulePath;
        this.parent = parent;
        this.opens = opens;
    }

    protected LayerConfig(List<OpensDirective> opens) {
        this.label = BOOT_LABEL;
        this.modulePath = null;
        this.parent = null;
        this.key = BOOT_LABEL;
        this.opens = opens;
    }

    public static LayerConfig ofUnresolved(String label, Path modulePath, String parent, List<OpensDirective> opens) {
        if (BOOT_LABEL.equals(label)) {
            throw new IllegalArgumentException("Cannot configure $boot layer.");
        }
        if (BOOT_LABEL.equals(parent)) {
            throw new IllegalArgumentException("Cannot use $boot layer as parent.");
        }
        return new LayerConfig(label, modulePath, parent, opens);
    }

    public static LayerConfig ofBoot() {
        return new LayerConfig(List.of());
    }

    public boolean isBoot() {
        return this.key == BOOT_LABEL;
    }

    public String getLabel() {
        return this.label;
    }

    public Path getModulePath() {
        return this.modulePath;
    }

    public String getParent() {
        return this.parent;
    }

    public List<OpensDirective> getOpens() {
        return this.opens;
    }

    protected void checkResolved() {
        if (this.key == null) {
            throw new IllegalArgumentException("Layer [" + this.label + "] is not yet resolved.");
        }
    }

    public String getParentKey() {
        this.checkResolved();
        return this.parentKey;
    }

    String getKey() {
        this.checkResolved();
        return this.key;
    }

    public String resolve(Map<String, LayerConfig> unresolved) {
        if (this.key == null) {
            if (this.parent == null) {
                this.parentKey = null;
                this.key = this.label;
            } else {
                if (this.label.equals(this.parent)) {
                    throw new IllegalArgumentException("Layer [" + this.label + "] references itself as a parent.");
                }
                LayerConfig p = unresolved.get(this.parent);
                if (p == null) {
                    throw new IllegalArgumentException("Cannot resolve parent layer [" + this.parent + "] of layer [" + this.label + "].");
                }
                this.parentKey = p.resolve(unresolved);
                this.key = this.parentKey + "." + this.label;
            }
        }
        return this.key;
    }
}

