/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.clazzes.svc.api.CoreService;
import org.clazzes.svc.runner.Config;
import org.clazzes.svc.runner.SecretsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreServiceImpl
implements CoreService,
Destroyable {
    private static final Logger log = LoggerFactory.getLogger(CoreServiceImpl.class);
    public static final String EXECUTOR_POOL_SIZE_PROPERTY = "svc.runner.executorPoolSize";
    public static final String SCHEDULED_EXECUTOR_POOL_SIZE_PROPERTY = "svc.runner.scheduledExecutorPoolSize";
    public static final String STOP_EXECUTOR_TRIES_PROPERTY = "svc.runner.stopExecutorTries";
    public static final String SECRETS_MASTER_KEY_PROPERTY = "svc.runner.secretsMasterKey";
    protected static final CoreServiceImpl INSTANCE = new CoreServiceImpl();
    private ExecutorService executorService;
    private ScheduledExecutorService scheduledExecutorService;
    private SecretsStore secretsStore;
    private boolean destroyed;
    private final int stopExecutorTries = Config.getIntProperty("svc.runner.stopExecutorTries", 30);

    public static final CoreService provider() {
        return INSTANCE;
    }

    protected void init() {
        int executorPoolSize = Config.getIntProperty(EXECUTOR_POOL_SIZE_PROPERTY, 4);
        int scheduledExecutorPoolSize = Config.getIntProperty(SCHEDULED_EXECUTOR_POOL_SIZE_PROPERTY, 4);
        this.executorService = Executors.newFixedThreadPool(executorPoolSize);
        this.scheduledExecutorService = Executors.newScheduledThreadPool(scheduledExecutorPoolSize);
        String secretsMasterKey = Config.getProperty(SECRETS_MASTER_KEY_PROPERTY, System.getenv("SVCRUNNER_SECRETS_MK"));
        if (secretsMasterKey == null) {
            this.secretsStore = null;
        } else {
            Properties props = new Properties();
            Config.loadSecretsProperties(props);
            this.secretsStore = new SecretsStore(props, secretsMasterKey);
            log.info("Successfully initialized secrets store with KVC [{}].", (Object)this.secretsStore.getKvc());
        }
    }

    protected CoreServiceImpl() {
        this.init();
    }

    public Path getEtcDir() {
        return Config.getEtcDir();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public String getSecret(String pid, String scheme, String key) {
        log.info("PID [" + pid + "] is requesting secret for key [" + scheme + ":" + key + "]");
        try {
            if ("prop".equals(scheme)) {
                if (this.secretsStore == null) {
                    throw new UnsupportedOperationException("SVC secrets store is not configured, define SVCRUNNER_SECRETS_MK environment variable or svc.runner.secretsMasterKey config variable.");
                }
                return this.secretsStore.decrypt(pid, key);
            }
            if ("conf".equals(scheme)) {
                return Config.getProperty(key);
            }
            if ("env".equals(scheme)) {
                return System.getenv(key);
            }
            if ("void".equals(scheme)) {
                return "";
            }
            throw new IllegalArgumentException("Unsupported key scheme [" + scheme + "], must be [prop], [env] or [void].");
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching secret key [" + key + "] for PID [" + pid + "]", e);
        }
    }

    private void shutdownService(ExecutorService service, String label) {
        log.info("Shutting down " + label + "...");
        List<Runnable> runnables = service.shutdownNow();
        if (runnables != null) {
            for (Runnable runnable : runnables) {
                log.warn("Runnable [" + String.valueOf(runnable) + "] has not been run by " + label + " before shutdown.");
            }
        }
        try {
            int ntries = 0;
            while (ntries < this.stopExecutorTries && !service.awaitTermination(1L, TimeUnit.SECONDS)) {
                log.info("Waiting for " + label + " to terminate (try " + ++ntries + ")...");
            }
            if (ntries < this.stopExecutorTries) {
                log.info(label + " has terminated after [" + ntries + "] tries.");
            } else {
                log.warn(label + " did not terminate after [" + ntries + "] tries.");
            }
        }
        catch (InterruptedException e) {
            log.warn("Waiting for " + label + " to terminate has been interrupted.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (this.scheduledExecutorService != null) {
            this.shutdownService(this.scheduledExecutorService, "ScheduledExecutorService");
            this.scheduledExecutorService = null;
        }
        if (this.executorService != null) {
            this.shutdownService(this.executorService, "ExecutorService");
            this.executorService = null;
        }
        this.secretsStore = null;
        CoreServiceImpl coreServiceImpl = this;
        synchronized (coreServiceImpl) {
            this.destroyed = true;
            this.notifyAll();
        }
    }

    @Override
    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public synchronized boolean waitForDestroy(long timeout) throws InterruptedException {
        if (!this.destroyed) {
            this.wait(timeout);
        }
        return this.destroyed;
    }

    public static void destroyInstance() {
        log.info("Destroying CoreService.");
        try {
            INSTANCE.destroy();
        }
        catch (Throwable e) {
            log.warn("Error destroying CoreService", e);
        }
    }
}

