/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.clazzes.svc.runner.SecretSupplier;
import org.clazzes.svc.runner.VarsSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFiles {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationFiles.class);
    public static final Pattern SECRET_PATTERN = Pattern.compile("^secret::(env|prop|void):(.*)$");
    public static final Pattern PID_PATTERN = Pattern.compile("^[a-z][a-z0-9]*(\\.[a-z][a-z0-9]*)+$");
    public static final String SERVICE_PID_KEY = "service.pid";
    public static final String SERVICE_TYPE_KEY = "service.type";
    public static final String SERVICE_TYPE_SECRET = "secret";
    public static final String SERVICE_TYPE_VARS = "vars";

    public static String getServicePid(Map<String, ?> config) {
        Object pid_o = config.get(SERVICE_PID_KEY);
        if (pid_o instanceof String) {
            String pid = (String)pid_o;
            return pid;
        }
        throw new IllegalArgumentException("Configuration map does not contain a service.pid property.");
    }

    public static Map<String, Map<String, ?>> readYaml(InputStream is, String path) throws IOException {
        YAMLMapper yamlMapper = new YAMLMapper();
        JsonParser parser = yamlMapper.createParser(is);
        JavaType jt = TypeFactory.defaultInstance().constructParametricType(Map.class, new Class[]{String.class, Object.class});
        MappingIterator it = yamlMapper.readValues(parser, jt);
        HashMap ret = new HashMap();
        int section = 0;
        while (it.hasNext()) {
            Map values = (Map)it.next();
            ++section;
            Object pid_o = values.get(SERVICE_PID_KEY);
            if (pid_o instanceof String) {
                String pid = (String)pid_o;
                if (PID_PATTERN.matcher(pid).matches()) {
                    ConfigurationFiles.replaceNewSecrets(pid, null, values);
                    log.info("Parsed section [{}] with PID [{}] from file [{}]", new Object[]{section, pid, path});
                    Map dup = ret.put(pid, values);
                    if (dup == null) continue;
                    log.warn("Replaced duplicate PID [{}] in file [{}]", (Object)pid, (Object)path);
                    continue;
                }
                log.warn("Section [{}] in file [{}] contains invalid service.pid [{}], ignoring it.", new Object[]{section, path, pid});
                continue;
            }
            log.warn("Section [{}] in file [{}] contains no service.pid property, ignoring it.", (Object)section, (Object)path);
        }
        return ret;
    }

    protected static void replaceNewSecrets(String pid, String ctxt, Map<String, Object> cfg) {
        for (String k : cfg.keySet()) {
            Object v = cfg.get(k);
            if (!(v instanceof Map)) continue;
            Map sub = (Map)v;
            Object serviceType = sub.get(SERVICE_TYPE_KEY);
            if (serviceType == null) {
                ConfigurationFiles.replaceNewSecrets(pid, (String)(ctxt == null ? k : ctxt + "." + k), sub);
                continue;
            }
            if (SERVICE_TYPE_SECRET.equals(serviceType)) {
                String scheme = null;
                String key = null;
                if (sub.size() == 3) {
                    String s;
                    Object scheme_o = sub.get("scheme");
                    Object key_o = sub.get("key");
                    if (scheme_o instanceof String) {
                        scheme = s = (String)scheme_o;
                    }
                    if (key_o instanceof String) {
                        key = s = (String)key_o;
                    }
                }
                if (scheme == null || key == null) {
                    throw new IllegalArgumentException("Map of [service.type=secret] does not have exactly 3 keys including [scheme] and [key].");
                }
                cfg.put(k, new SecretSupplier(pid, scheme, key));
                continue;
            }
            if (SERVICE_TYPE_VARS.equals(serviceType)) {
                Object expr_o;
                String expr = null;
                if (sub.size() == 2 && (expr_o = sub.get("expr")) instanceof String) {
                    String s;
                    expr = s = (String)expr_o;
                }
                if (expr == null) {
                    throw new IllegalArgumentException("Map of [service.type=vars] does not have exactly 2 keys including [expr].");
                }
                cfg.put(k, new VarsSupplier(pid, ctxt, cfg, "ref:" + k, expr));
                continue;
            }
            throw new IllegalArgumentException("Unknown [service.type=" + String.valueOf(serviceType) + "].");
        }
    }

    public static Map<String, Map<String, ?>> readYamlFile(Path p) {
        Map<String, Map<String, ?>> map;
        block8: {
            InputStream is = Files.newInputStream(p, new OpenOption[0]);
            try {
                map = ConfigurationFiles.readYaml(is, p.toString());
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Error reading yaml file [" + String.valueOf(p) + "]", (Throwable)e);
                    return null;
                }
            }
            is.close();
        }
        return map;
    }

    public static void writeYaml(OutputStream os, String path, Map<String, Map<String, ?>> configs) throws IOException {
        SimpleModule sm = new SimpleModule();
        sm.addSerializer(SecretSupplier.class, (JsonSerializer)new SecretSupplierJsonSerializer());
        sm.addSerializer(VarsSupplier.class, (JsonSerializer)new VarsSupplierJsonSerializer());
        YAMLMapper mapper = new YAMLMapper();
        mapper.configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true);
        mapper.registerModule((Module)sm);
        for (Map.Entry<String, Map<String, ?>> e : configs.entrySet()) {
            mapper.writeValue(os, e.getValue());
        }
    }

    public void writeYamlFile(Path p, Map<String, Map<String, ?>> configs) throws IOException {
        try (OutputStream os = Files.newOutputStream(p, new OpenOption[0]);){
            ConfigurationFiles.writeYaml(os, p.toString(), configs);
        }
    }

    public static Map<String, ?> readProperties(InputStream is, String pid, String path) throws IOException {
        log.info("Reading config PID [{}] from file [{}].", (Object)pid, (Object)path);
        JavaPropsMapper mapper = new JavaPropsMapper();
        JavaType jt = TypeFactory.defaultInstance().constructParametricType(Map.class, new Class[]{String.class, Object.class});
        Map values = (Map)mapper.readValue(is, jt);
        ConfigurationFiles.replaceLegacySecrets(pid, values);
        Object service = values.get("service");
        String svcPid = null;
        if (service instanceof Map) {
            Map map = (Map)service;
            Object svcPid_o = map.remove("pid");
            if (svcPid_o instanceof String) {
                String s;
                svcPid = s = (String)svcPid_o;
            }
            if (map.size() == 0) {
                values.remove("service");
            }
        }
        if (!pid.equals(svcPid)) {
            log.warn("File [{}] has wrong service.pid value, correcting it.", (Object)path);
        } else {
            log.info("File [{}] has correct service.pid value [{}].", (Object)path, svcPid);
        }
        values.put(SERVICE_PID_KEY, pid);
        return values;
    }

    protected static void replaceLegacySecrets(String pid, Map<String, Object> cfg) {
        for (String k : cfg.keySet()) {
            String s;
            Matcher m;
            Object v = cfg.get(k);
            if (v instanceof Map) {
                Map sub = (Map)v;
                ConfigurationFiles.replaceLegacySecrets(pid, sub);
                continue;
            }
            if (!(v instanceof String) || !(m = SECRET_PATTERN.matcher(s = (String)v)).matches()) continue;
            String scheme = m.group(1);
            String key = m.group(2);
            cfg.put(k, new SecretSupplier(pid, scheme, key));
        }
    }

    public static Map<String, ?> readCfgFile(Path p) {
        String fn = p.getFileName().toString();
        if (!fn.endsWith(".cfg")) {
            log.warn("Configuration file [{}] does not match [*.cfg].", (Object)p);
            return null;
        }
        String pid = fn.substring(0, fn.length() - 4);
        if (PID_PATTERN.matcher(pid).matches()) {
            Map<String, ?> map;
            block10: {
                InputStream is = Files.newInputStream(p, new OpenOption[0]);
                try {
                    map = ConfigurationFiles.readProperties(is, pid, p.toString());
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.error("Error reading cfg file [" + String.valueOf(p) + "]", (Throwable)e);
                        return null;
                    }
                }
                is.close();
            }
            return map;
        }
        log.warn("Ignoring cfg file [{}] with invalid PID.", (Object)p);
        return null;
    }

    protected static final class SecretSupplierJsonSerializer
    extends JsonSerializer<SecretSupplier> {
        protected SecretSupplierJsonSerializer() {
        }

        public void serialize(SecretSupplier value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName(ConfigurationFiles.SERVICE_TYPE_KEY);
            gen.writeString(ConfigurationFiles.SERVICE_TYPE_SECRET);
            gen.writeFieldName("scheme");
            gen.writeString(value.getScheme());
            gen.writeFieldName("key");
            gen.writeString(value.getKey());
            gen.writeEndObject();
        }
    }

    protected static final class VarsSupplierJsonSerializer
    extends JsonSerializer<VarsSupplier> {
        protected VarsSupplierJsonSerializer() {
        }

        public void serialize(VarsSupplier value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName(ConfigurationFiles.SERVICE_TYPE_KEY);
            gen.writeString(ConfigurationFiles.SERVICE_TYPE_VARS);
            gen.writeFieldName("expr");
            gen.writeString(value.getExpr());
            gen.writeEndObject();
        }
    }
}

