/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.clazzes.svc.api.ComponentInfo;
import org.clazzes.svc.api.ComponentLayerInfo;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ComponentState;
import org.clazzes.svc.api.ModuleInfo;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ThrowableInfo;
import org.clazzes.svc.runner.ComponentFilter;
import org.clazzes.svc.runner.ComponentHolder;
import org.clazzes.svc.runner.ComponentLayer;
import org.clazzes.svc.runner.Config;
import org.clazzes.svc.runner.HasContext;
import org.clazzes.svc.runner.LayerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentManagerImpl
extends HasContext
implements ComponentManager {
    private static final Logger log = LoggerFactory.getLogger(ComponentManagerImpl.class);
    private final Map<String, ComponentLayer> layers = new HashMap<String, ComponentLayer>();
    private final TreeMap<String, ComponentLayer> sortedLayers = new TreeMap();
    private final Map<ModuleLayer, ComponentLayer> layersByModuleLayer = new ConcurrentHashMap<ModuleLayer, ComponentLayer>();
    private final Map<String, ComponentHolder> componentsByModuleName = new ConcurrentHashMap<String, ComponentHolder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLayer(ComponentLayer layer) {
        ComponentManagerImpl componentManagerImpl = this;
        synchronized (componentManagerImpl) {
            this.layers.put(layer.getLabel(), layer);
            this.sortedLayers.put(layer.getKey(), layer);
            layer.getComponentsByModuleName().forEach(e -> {
                ComponentHolder old = this.componentsByModuleName.put((String)e.getKey(), (ComponentHolder)e.getValue());
                if (old != null) {
                    log.warn("Module name [{}] defines more than one component apart from [{}]", e.getKey(), (Object)old);
                }
            });
        }
        this.layersByModuleLayer.put(layer.getModuleLayer(), layer);
    }

    protected synchronized ComponentLayer fetchLayer(String lbl) {
        return this.layers.get(lbl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ComponentLayer removeLayer(String lbl) {
        ComponentLayer ret;
        ComponentManagerImpl componentManagerImpl = this;
        synchronized (componentManagerImpl) {
            ret = this.layers.remove(lbl);
            if (ret != null) {
                this.sortedLayers.remove(ret.getKey());
                ret.getComponentsByModuleName().forEach(e -> this.componentsByModuleName.remove(e.getKey()));
            }
        }
        if (ret != null) {
            this.layersByModuleLayer.remove(ret.getModuleLayer());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map.Entry<String, ComponentLayer>> fetchLayerList() {
        ArrayList<Map.Entry<String, ComponentLayer>> ret;
        ComponentManagerImpl componentManagerImpl = this;
        synchronized (componentManagerImpl) {
            ret = new ArrayList<Map.Entry<String, ComponentLayer>>(this.layers.entrySet());
        }
        ret.sort((a, b) -> ((ComponentLayer)a.getValue()).getKey().compareTo(((ComponentLayer)b.getValue()).getKey()));
        return ret;
    }

    protected List<Map.Entry<String, ComponentLayer>> fetchLayerList(ComponentFilter filter) {
        if (filter == null || filter.getLayer() == null) {
            return this.fetchLayerList();
        }
        ComponentLayer layer = this.fetchLayer(filter.getLayer());
        if (layer == null) {
            log.warn("Layer [{}] not found, returning empty component list.", (Object)layer);
            return Collections.emptyList();
        }
        return Collections.singletonList(new AbstractMap.SimpleEntry<String, ComponentLayer>(filter.getLayer(), layer));
    }

    protected ComponentLayer createLayer(LayerConfig layerConfig) {
        ModuleLayer parent;
        if (layerConfig.getParent() == null) {
            parent = ModuleLayer.boot();
        } else {
            ComponentLayer parentLayer = this.fetchLayer(layerConfig.getParent());
            if (parentLayer == null) {
                throw new IllegalStateException("Cannot find parent layer [" + layerConfig.getParent() + "] for [" + layerConfig.getKey() + "]");
            }
            parent = parentLayer.getModuleLayer();
        }
        log.info("Resolving layer [{}] for path [{}]", (Object)layerConfig.getKey(), (Object)layerConfig.getModulePath());
        ComponentLayer layer = ComponentLayer.of(layerConfig, parent, layerConfig.getModulePath());
        this.addLayer(layer);
        return layer;
    }

    public void startBootLayers(ServiceContext svcCtxt) {
        if (this.fetchLayer("$boot") != null) {
            throw new IllegalStateException("ComponentManagerImpl.startBootLayers() called twice.");
        }
        ComponentLayer boot = ComponentLayer.of(ModuleLayer.boot(), System.getProperty("jdk.module.path"));
        log.info("Resolving layer [{}] for path [{}] with opens {}", new Object[]{boot.getLabel(), boot.getPath(), boot.getLayerConfig().getOpens()});
        this.addLayer(boot);
        for (Map.Entry<String, LayerConfig> entry : Config.getSortedLayerConfigs().entrySet()) {
            this.createLayer(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.sortedLayers.entrySet()) {
            log.info("Starting layer [{}].", (Object)entry.getKey());
            ((ComponentLayer)entry.getValue()).startAll(svcCtxt);
        }
        this.setContext(svcCtxt);
    }

    public void stopLayers(long stopTimeout) {
        ServiceContext svcCtxt = this.getContext();
        for (String key : this.sortedLayers.descendingKeySet()) {
            log.info("Deactivating layer [{}].", (Object)key);
            ComponentLayer layer = this.sortedLayers.get(key);
            layer.stopAll(svcCtxt, stopTimeout);
        }
        this.clearContext();
    }

    public List<ComponentLayerInfo> listLayers() {
        List<Map.Entry<String, ComponentLayer>> layerList = this.fetchLayerList();
        ArrayList<ComponentLayerInfo> ret = new ArrayList<ComponentLayerInfo>(layerList.size());
        for (Map.Entry<String, ComponentLayer> e : layerList) {
            ret.add(new ComponentLayerInfo(e.getKey(), e.getValue().getPath(), e.getValue().getParentLabel()));
        }
        return ret;
    }

    protected static void listModulesOfLayer(List<ModuleInfo> ret, String layerLbl, ComponentLayer layer) {
        for (ResolvedModule m : layer.getModuleLayer().configuration().modules()) {
            ModuleReference ref = m.reference();
            ret.add(new ModuleInfo(layerLbl, ref.descriptor().name(), ref.descriptor().version(), ref.location()));
        }
    }

    public List<ModuleInfo> listModules() {
        ArrayList<ModuleInfo> ret = new ArrayList<ModuleInfo>(256);
        for (Map.Entry<String, ComponentLayer> e : this.fetchLayerList()) {
            ComponentManagerImpl.listModulesOfLayer(ret, e.getKey(), e.getValue());
        }
        Collections.sort(ret);
        return ret;
    }

    public List<ModuleInfo> listModules(String layer) {
        ArrayList<ModuleInfo> ret = new ArrayList<ModuleInfo>(128);
        ComponentLayer realLayer = this.fetchLayer(layer);
        if (realLayer != null) {
            ComponentManagerImpl.listModulesOfLayer(ret, layer, realLayer);
        } else {
            log.warn("Layer [{}] not found, returning empty module list.", (Object)layer);
        }
        Collections.sort(ret);
        return ret;
    }

    protected static void listComponentsOfLayer(List<ComponentInfo> ret, String layerLbl, ComponentLayer layer, ComponentFilter filter) {
        for (ComponentHolder h : layer.getComponents()) {
            Class cls = h.getComponent().getClass();
            Module m = cls.getModule();
            ModuleDescriptor md = m.getDescriptor();
            if (log.isDebugEnabled()) {
                log.debug("filter,layerLbl,h,matches={},{},{},{}", new Object[]{filter, layerLbl, h, filter == null ? false : filter.matches(layerLbl, h)});
            }
            if (filter != null && !filter.matches(layerLbl, h)) continue;
            Optional<ResolvedModule> rm = m.getLayer().configuration().findModule(md.name());
            Optional<Object> location = rm.isPresent() && Objects.equals(md, rm.get().reference().descriptor()) ? rm.get().reference().location() : Optional.empty();
            ModuleInfo mi = new ModuleInfo(layerLbl, md.name(), md.version(), location);
            ComponentInfo ci = new ComponentInfo(cls.getName(), h.getPriority(), h.getState(), mi, h.getThrowables());
            ret.add(ci);
        }
    }

    public List<ComponentInfo> listComponents() {
        ArrayList<ComponentInfo> ret = new ArrayList<ComponentInfo>(256);
        for (Map.Entry<String, ComponentLayer> e : this.fetchLayerList()) {
            ComponentManagerImpl.listComponentsOfLayer(ret, e.getKey(), e.getValue(), null);
        }
        Collections.sort(ret);
        return ret;
    }

    public List<ComponentInfo> listComponents(String filter) {
        if (filter == null) {
            return this.listComponents();
        }
        ComponentFilter cf = ComponentFilter.of(filter);
        ArrayList<ComponentInfo> ret = new ArrayList<ComponentInfo>(256);
        for (Map.Entry<String, ComponentLayer> e : this.fetchLayerList(cf)) {
            ComponentManagerImpl.listComponentsOfLayer(ret, e.getKey(), e.getValue(), cf);
        }
        Collections.sort(ret);
        return ret;
    }

    protected static void startComponentsOfLayer(ServiceContext svcCtxt, String layerLbl, ComponentLayer layer, ComponentFilter filter) {
        for (ComponentHolder h : layer.getComponents()) {
            if (filter != null && !filter.matches(layerLbl, h)) continue;
            ComponentLayer.startComponent(svcCtxt, h);
        }
    }

    public void startComponent(String component) {
        ComponentFilter cf = ComponentFilter.of(component);
        for (Map.Entry<String, ComponentLayer> e : this.fetchLayerList(cf)) {
            ComponentManagerImpl.startComponentsOfLayer(this.getContext(), e.getKey(), e.getValue(), cf);
        }
    }

    protected static void stopComponentsOfLayer(ServiceContext svcCtxt, String layerLbl, ComponentLayer layer, ComponentFilter filter) {
        for (ComponentHolder h : layer.getComponents()) {
            if (filter != null && !filter.matches(layerLbl, h)) continue;
            ComponentLayer.stopComponent(svcCtxt, h, 10000L);
        }
    }

    public void stopComponent(String component) {
        ComponentFilter cf = ComponentFilter.of(component);
        for (Map.Entry<String, ComponentLayer> e : this.fetchLayerList(cf)) {
            ComponentManagerImpl.stopComponentsOfLayer(this.getContext(), e.getKey(), e.getValue(), cf);
        }
    }

    public void reloadLayer(String label, long timeout) {
        if ("$boot".equals(label)) {
            throw new IllegalArgumentException("The boot layer may not be reloaded.");
        }
        ServiceContext svcCtxt = this.getContext();
        ComponentLayer oldLayer = this.removeLayer(label);
        if (oldLayer == null) {
            throw new IllegalArgumentException("Layer [" + label + "] does not exist.");
        }
        oldLayer.stopAll(svcCtxt, timeout);
        try {
            svcCtxt.synchronize(timeout);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Reload of layer [" + label + "] has been interrupted", e);
        }
        LayerConfig layerConfig = oldLayer.getLayerConfig();
        ComponentLayer newLayer = this.createLayer(layerConfig);
        newLayer.startAll(svcCtxt);
    }

    protected ComponentHolder resolveComponent(Class<?> cls) {
        Module module = cls.getModule();
        ComponentLayer cl = this.layersByModuleLayer.get(module.getLayer());
        if (cl == null) {
            return null;
        }
        return cl.getByModule(module);
    }

    protected static final String makeTrace(StackWalker sw) {
        return sw.walk(s -> s.map(f -> f.toStackTraceElement().toString()).collect(Collectors.joining("\n  ")));
    }

    protected Optional<ComponentHolder> resolveComponent() {
        StackWalker sw = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        Optional ret = sw.walk(s -> s.map(f -> this.resolveComponent(f.getDeclaringClass())).filter(Objects::nonNull).findFirst());
        if (ret.isEmpty()) {
            log.warn("Cannot map stack trace to component:\n  {}", (Object)ComponentManagerImpl.makeTrace(sw));
        } else if (log.isDebugEnabled()) {
            log.debug("Mapped stack to [{}]:\n  {}", ret.get(), (Object)ComponentManagerImpl.makeTrace(sw));
        }
        return ret;
    }

    public void commit() {
        this.resolveComponent().ifPresent(ch -> {
            ch.checkState(ComponentState.COMMITTED, ComponentState.STARTING, ComponentState.STARTED, ComponentState.COMMITTED);
            log.info("Committed component [{}]", ch);
        });
    }

    protected static final String makeTrace(Throwable throwable) {
        return Arrays.stream(throwable.getStackTrace()).map(Object::toString).collect(Collectors.joining("\n  "));
    }

    protected Optional<ComponentHolder> resolveComponent(Throwable throwable) {
        Optional<ComponentHolder> ret = Arrays.stream(throwable.getStackTrace()).map(f -> this.componentsByModuleName.get(f.getModuleName())).filter(Objects::nonNull).findFirst();
        if (ret.isEmpty()) {
            log.warn("Cannot map throwable stack trace to component:\n  {}", (Object)ComponentManagerImpl.makeTrace(throwable));
        } else if (log.isDebugEnabled()) {
            log.debug("Mapped throwable stack to [{}]:\n  {}", (Object)ret.get(), (Object)ComponentManagerImpl.makeTrace(throwable));
        }
        return ret;
    }

    public void recordConfigException(ThrowableInfo throwable) {
        this.resolveComponent(throwable.getThrowable()).ifPresent(c -> {
            c.checkState(ComponentState.CONFIG_LISTENER_FAILED, ComponentState.CONFIG_LISTENER_FAILED, ComponentState.SERVICE_LISTENER_FAILED, ComponentState.STARTED, ComponentState.COMMITTED);
            c.addThrowable(throwable);
        });
    }

    public void recordServiceException(ThrowableInfo throwable) {
        this.resolveComponent(throwable.getThrowable()).ifPresent(c -> {
            c.checkState(ComponentState.SERVICE_LISTENER_FAILED, ComponentState.CONFIG_LISTENER_FAILED, ComponentState.SERVICE_LISTENER_FAILED, ComponentState.STARTED, ComponentState.COMMITTED);
            c.addThrowable(throwable);
        });
    }
}

