/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServicePriority;
import org.clazzes.svc.runner.ComponentHolder;
import org.clazzes.svc.runner.LayerConfig;
import org.clazzes.svc.runner.OpensDirective;
import org.clazzes.svc.runner.opener.Opener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentLayer {
    private static final Logger log = LoggerFactory.getLogger(ComponentLayer.class);
    private final LayerConfig layerConfig;
    private final ModuleLayer moduleLayer;
    private final String path;
    private final List<ComponentHolder> components;
    private final Map<Module, ComponentHolder> componentsByModule;

    protected ComponentLayer(LayerConfig layerConfig, ModuleLayer moduleLayer, String path, List<ComponentHolder> components) {
        this.layerConfig = layerConfig;
        this.moduleLayer = moduleLayer;
        this.path = path;
        this.components = components;
        this.componentsByModule = new HashMap<Module, ComponentHolder>();
        for (ComponentHolder component : components) {
            Module module = component.getComponent().getClass().getModule();
            ComponentHolder old = this.componentsByModule.put(module, component);
            if (old == null) continue;
            log.warn("Module [{}] defines more than one compnent apart from [{}]", (Object)module, (Object)old);
        }
    }

    protected static ComponentLayer resolve(LayerConfig layerConfig, ModuleLayer moduleLayer, String path) {
        for (OpensDirective open : layerConfig.getOpens()) {
            log.info("Precessing opens directive [{}]...", (Object)open);
            Optional<Module> src = moduleLayer.findModule(open.getSourceModule());
            if (src.isEmpty()) {
                log.warn("Cannot find source module [{}] in layer [{}]", (Object)open.getSourceModule(), (Object)layerConfig.getKey());
                continue;
            }
            Optional<Module> target = moduleLayer.findModule(open.getTargetModule());
            if (target.isEmpty()) {
                log.warn("Cannot find target module [{}] in layer [{}]", (Object)open.getTargetModule(), (Object)layerConfig.getKey());
                continue;
            }
            Opener.addOpens((Module)src.get(), (String)open.getSourcePackage(), (Module)target.get());
            log.info("Successfully opened package [{}] of [{}] to [{}].", new Object[]{open.getSourcePackage(), src.get(), target.get()});
        }
        ServiceLoader<Component> loader = ServiceLoader.load(moduleLayer, Component.class);
        ArrayList<ComponentHolder> components = new ArrayList<ComponentHolder>();
        loader.stream().filter(p -> moduleLayer.equals(p.type().getModule().getLayer())).forEach(p -> {
            Component component = (Component)p.get();
            ServicePriority priority = component.getClass().getAnnotation(ServicePriority.class);
            ComponentHolder ch = new ComponentHolder(component, priority);
            components.add(ch);
            log.info("Resolved component [{}] with priority [{}].", (Object)ch.getClassName(), (Object)ch.getPriority());
        });
        Collections.sort(components);
        return new ComponentLayer(layerConfig, moduleLayer, path, components);
    }

    public static ComponentLayer of(ModuleLayer moduleLayer, String path) {
        List allNames = moduleLayer.configuration().modules().stream().map(m -> m.name()).collect(Collectors.toList());
        Collections.sort(allNames);
        log.info("Creating boot layer for path [{}] with modules {}", (Object)path, allNames);
        return ComponentLayer.resolve(LayerConfig.ofBoot(), moduleLayer, path);
    }

    public static ComponentLayer of(LayerConfig layerConfig, ModuleLayer parent, Path path) {
        ModuleFinder finder = ModuleFinder.of(path);
        if (log.isDebugEnabled()) {
            log.debug("Path [{}] contains modules [{}]", (Object)path, finder.findAll());
        }
        List<String> allNames = finder.findAll().stream().map(m -> m.descriptor().name()).collect(Collectors.toList());
        Collections.sort(allNames);
        log.info("Creating layer for path [{}] with modules {}", (Object)path, allNames);
        Configuration cf = parent.configuration().resolve(finder, ModuleFinder.of(new Path[0]), allNames);
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        ModuleLayer.Controller nl = ModuleLayer.defineModulesWithOneLoader(cf, List.of(parent), scl);
        return ComponentLayer.resolve(layerConfig, nl.layer(), path.toString());
    }

    public String getParentLabel() {
        String ret = this.layerConfig.getParent();
        if (ret != null || this.layerConfig.isBoot()) {
            return ret;
        }
        return "$boot";
    }

    public String getLabel() {
        return this.layerConfig.getLabel();
    }

    public String getKey() {
        return this.layerConfig.getKey();
    }

    public LayerConfig getLayerConfig() {
        return this.layerConfig;
    }

    public ModuleLayer getModuleLayer() {
        return this.moduleLayer;
    }

    public List<ComponentHolder> getComponents() {
        return this.components;
    }

    public ComponentHolder getByModule(Module module) {
        return this.componentsByModule.get(module);
    }

    public Stream<Map.Entry<String, ComponentHolder>> getComponentsByModuleName() {
        return this.componentsByModule.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, ComponentHolder>(((Module)e.getKey()).getName(), (ComponentHolder)e.getValue()));
    }

    public String getPath() {
        return this.path;
    }

    public static void startComponent(ServiceContext svcCtxt, ComponentHolder component) {
        svcCtxt.scheduleManipulator(() -> {
            try {
                component.starting(Thread.currentThread());
            }
            catch (Throwable e) {
                log.error("Unable to initiate start of component [{}].", (Object)component);
                return;
            }
            try {
                log.info("Starting component [{}]...", (Object)component);
                component.getComponent().start(svcCtxt);
                component.started();
                log.info("Component [{}] started successfully.", (Object)component);
            }
            catch (Throwable e) {
                component.startFailed();
                component.error(log, "Starting component [{}] failed", component, e);
            }
        });
    }

    public void startAll(ServiceContext svcCtxt) {
        for (ComponentHolder component : this.components) {
            ComponentLayer.startComponent(svcCtxt, component);
        }
    }

    public static void stopComponent(ServiceContext svcCtxt, ComponentHolder component, long timeout) {
        svcCtxt.scheduleManipulator(() -> {
            try {
                component.stopTransition(timeout, msg -> log.info(msg));
                component.stopping(Thread.currentThread());
            }
            catch (Throwable e) {
                log.error("Unable to initiate stop of component [{}]", (Object)component, (Object)e);
                return;
            }
            try {
                log.info("Stopping component [{}]...", (Object)component);
                component.getComponent().stop(svcCtxt);
                component.stopped();
                log.info("Component [{}] stopped successfully.", (Object)component);
            }
            catch (Throwable e) {
                component.stopFailed();
                component.error(log, "Stopping component [{}] failed", component, e);
            }
        });
    }

    public void stopAll(ServiceContext svcCtxt, long timeout) {
        int i = this.components.size();
        while (--i >= 0) {
            ComponentHolder component = this.components.get(i);
            ComponentLayer.stopComponent(svcCtxt, component, timeout);
        }
    }
}

