/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import org.clazzes.svc.runner.Config;
import org.clazzes.svc.runner.CoreServiceImpl;
import org.clazzes.svc.runner.ServiceContextImpl;
import org.clazzes.svc.runner.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap {
    private static final Logger log = LoggerFactory.getLogger(Bootstrap.class);
    static ServiceContextImpl svcCtxt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Setup.setup();
        String mode = null;
        if (args != null && args.length == 1) {
            mode = args[0];
        }
        if ("start".equals(mode)) {
            try {
                int keepaliveTimeout = Config.getIntProperty("svc.runner.keepaliveTimeout", 10000);
                Config.registerSecurityProviders();
                svcCtxt = new ServiceContextImpl();
                svcCtxt.start();
                CoreServiceImpl cs = CoreServiceImpl.INSTANCE;
                while (!cs.waitForDestroy(keepaliveTimeout)) {
                    log.info("KEEPALIVE: Windows Service.");
                }
            }
            catch (Throwable e) {
                log.error("Unexpected error running svc-runner Windows Service", e);
            }
            log.info("Leaving svc-runner Windows Service.");
        } else if ("stop".equals(mode)) {
            try {
                int stopTimeout = Config.getIntProperty("svc.runner.stopTimeout", 10000);
                svcCtxt.stop(stopTimeout);
                svcCtxt.synchronize(stopTimeout);
            }
            catch (Throwable e) {
                log.error("Unexpected error stopping svc-runner Windows Service", e);
            }
            finally {
                CoreServiceImpl.destroyInstance();
                Setup.stopLogback();
            }
        } else {
            throw new IllegalArgumentException("Unrecognized command line parameters sepcified (must be \"start\" or \"stop\").");
        }
    }
}

