package org.clazzes.svc.runner;

import org.clazzes.svc.api.ServiceContext;

public abstract class HasContext {

    private ServiceContext serviceContext;

    synchronized protected void setContext(ServiceContext svcCtxt) {

        if (this.serviceContext != null) {
            throw new IllegalStateException(this.getClass().getSimpleName()+" already initialized.");
        }
        this.serviceContext = svcCtxt;
    }

    synchronized protected void clearContext() {

        this.serviceContext = null;
    }

    synchronized protected ServiceContext getContext() {

        if (this.serviceContext == null) {
            throw new IllegalStateException(this.getClass().getSimpleName()+" not initialized.");
        }
        return this.serviceContext;
    }

}
