/***********************************************************
*
* Service Runner of the clazzes.org project
* https://www.clazzes.org
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
***********************************************************/

import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.CoreService;
import org.clazzes.svc.runner.CoreServiceImpl;

module org.clazzes.svc.runner.core {

    exports org.clazzes.svc.runner;

    uses Component;

    requires org.clazzes.svc.runner.opener;
    requires transitive org.clazzes.svc.api;

    requires transitive org.slf4j;
    requires jul.to.slf4j;
    requires org.apache.commons.logging;
    requires java.logging;
    requires com.fasterxml.jackson.dataformat.javaprop;
    requires com.fasterxml.jackson.databind;
    requires com.fasterxml.jackson.dataformat.yaml;
    requires ch.qos.logback.classic;

    provides CoreService with CoreServiceImpl;
}
