/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.clazzes.svc.api.ConfigurationHelper;
import org.clazzes.svc.api.CoreService;
import org.clazzes.svc.runner.CoreServiceImpl;
import org.clazzes.svc.runner.VariableSubstition;

public class VarsSupplier
implements Supplier<String> {
    public static final Pattern VARIABLE_PATTERN = Pattern.compile("^(env|prop|conf|void|ref):([^:]*)(:-(.*))?$");
    private final String pid;
    private final String context;
    private final Map<String, Object> content;
    private final String key;
    private final String expr;
    private final ThreadLocal<Boolean> cycleCheck;

    public VarsSupplier(String pid, String context, Map<String, Object> content, String key, String expr) {
        this.pid = pid;
        this.context = context;
        this.content = content;
        this.expr = expr;
        this.key = key;
        this.cycleCheck = new ThreadLocal();
    }

    @Override
    public String get() {
        if (this.cycleCheck.get() != null) {
            throw new IllegalArgumentException("Recursive evaluation of [" + this.key + "] in expression [" + this.expr + "].");
        }
        try {
            this.cycleCheck.set(Boolean.TRUE);
            String string = VariableSubstition.substVars(this.expr, this.key, v -> {
                Matcher m = VARIABLE_PATTERN.matcher((CharSequence)v);
                if (m.matches()) {
                    String def;
                    String scheme = m.group(1);
                    String key = m.group(2);
                    String string = def = m.groupCount() == 4 ? m.group(4) : null;
                    if ("ref".equals(scheme)) {
                        if (def == null) {
                            return ConfigurationHelper.getMandatoryString(this.content, (String)key);
                        }
                        return ConfigurationHelper.getString(this.content, (String)key, (String)def);
                    }
                    CoreService coreService = CoreServiceImpl.provider();
                    String ret = coreService.getSecret(this.pid, scheme, key);
                    return ret == null ? def : ret;
                }
                throw new IllegalArgumentException("Invalid Variable [" + v + "] (must match [" + String.valueOf(VARIABLE_PATTERN) + "]).");
            });
            return string;
        }
        finally {
            this.cycleCheck.remove();
        }
    }

    public String getPid() {
        return this.pid;
    }

    public String getExpr() {
        return this.expr;
    }

    public String toString() {
        return "VarsSupplier [pid=" + this.pid + ", context=" + this.context + ", key=" + this.key + ", expr=" + this.expr + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pid == null ? 0 : this.pid.hashCode());
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VarsSupplier other = (VarsSupplier)obj;
        if (this.pid == null ? other.pid != null : !this.pid.equals(other.pid)) {
            return false;
        }
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
    }
}

