/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.clazzes.svc.runner.Config;
import org.clazzes.svc.runner.ServiceContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitTestSupport
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(UnitTestSupport.class);
    private final ServiceContextImpl serviceContext;

    protected UnitTestSupport(ServiceContextImpl serviceContext) {
        this.serviceContext = serviceContext;
    }

    public ServiceContextImpl getServiceContext() {
        return this.serviceContext;
    }

    public static UnitTestSupport before(String configYaml) throws Exception {
        return UnitTestSupport.before(new ByteArrayInputStream(configYaml.getBytes(StandardCharsets.UTF_8)), "before-parameter");
    }

    public static UnitTestSupport before(InputStream configYaml, String configResource) throws Exception {
        ServiceContextImpl serviceContext = new ServiceContextImpl();
        serviceContext.startForTest(configYaml, configResource);
        return new UnitTestSupport(serviceContext);
    }

    @Override
    public void close() throws Exception {
        int stopTimeout = Config.getIntProperty("svc.runner.stopTimeout", 10000);
        this.serviceContext.stop(stopTimeout);
    }

    static {
        try {
            Config.registerSecurityProviders();
        }
        catch (Exception e) {
            log.error("Error registering security providers in svc-runenr Unit Test support.", (Throwable)e);
        }
    }
}

