/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.CoreService;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.svc.runner.ComponentManagerImpl;
import org.clazzes.svc.runner.ConfigurationEngineImpl;
import org.clazzes.svc.runner.CoreServiceImpl;
import org.clazzes.svc.runner.ServiceRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceContextImpl
implements ServiceContext {
    private static final Logger log = LoggerFactory.getLogger(ServiceContextImpl.class);
    private final Map<Class<?>, Object> services = new HashMap();
    private final ConfigurationEngineImpl configurationEngine;
    private final ServiceRegistryImpl serviceRegistry;
    private final ComponentManagerImpl componentManager;
    private int submitted = 0;
    private int counter = 0;

    public ServiceContextImpl() {
        this.services.put(CoreService.class, CoreServiceImpl.INSTANCE);
        this.configurationEngine = new ConfigurationEngineImpl();
        this.services.put(ConfigurationEngine.class, this.configurationEngine);
        this.serviceRegistry = new ServiceRegistryImpl();
        this.services.put(ServiceRegistry.class, this.serviceRegistry);
        this.componentManager = new ComponentManagerImpl();
        this.services.put(ComponentManager.class, this.componentManager);
    }

    public <T> Optional<T> getService(Class<T> iface) {
        return Optional.ofNullable(this.services.get(iface));
    }

    public void start() {
        this.configurationEngine.start(this);
        this.serviceRegistry.start(this);
        this.componentManager.startBootLayers(this);
    }

    public void startForTest(InputStream configYaml, String configResource) throws IOException {
        this.configurationEngine.loadTestYaml(this, configYaml, configResource);
        this.serviceRegistry.start(this);
        this.componentManager.startBootLayers(this);
    }

    public void stop(int timeoutMillis) {
        this.componentManager.stopLayers(timeoutMillis);
        try {
            this.synchronize(timeoutMillis);
        }
        catch (InterruptedException e) {
            log.warn("Synchronization before serivce registry stop has been interrupted", (Throwable)e);
        }
        this.serviceRegistry.stop();
        this.configurationEngine.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manipulatorStarted() {
        int nsubmitted;
        int njobs;
        ServiceContextImpl serviceContextImpl = this;
        synchronized (serviceContextImpl) {
            njobs = ++this.counter;
            nsubmitted = --this.submitted;
        }
        if (log.isDebugEnabled()) {
            log.debug("ServiceContextImpl.manipulatorStarted nsubmitted,njobs=[{},{}]", (Object)nsubmitted, (Object)njobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manipulatorStopped() {
        ServiceContextImpl serviceContextImpl = this;
        synchronized (serviceContextImpl) {
            int njobs = --this.counter;
            if (log.isDebugEnabled()) {
                log.debug("ServiceContextImpl.manipulatorStopped njobs=[{}]", (Object)njobs);
            }
            if (njobs == 0) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainpulatorScheduled() {
        int nsubmitted;
        ServiceContextImpl serviceContextImpl = this;
        synchronized (serviceContextImpl) {
            nsubmitted = ++this.submitted;
        }
        if (log.isDebugEnabled()) {
            log.debug("ServiceContextImpl.manipulatorScheduled nsubmitted=[{}]", (Object)nsubmitted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int waitForManipulatorDecrement(long millis) throws InterruptedException {
        int njobs;
        ServiceContextImpl serviceContextImpl = this;
        synchronized (serviceContextImpl) {
            njobs = this.counter + this.submitted;
            if (njobs != 0) {
                this.wait(millis);
            }
            njobs = this.counter + this.submitted;
        }
        if (log.isDebugEnabled()) {
            log.debug("ServiceContextImpl.waitForManipulatorDecrement njobs=[{}]", (Object)njobs);
        }
        return njobs;
    }

    public void synchronize(long timeoutMillis) throws InterruptedException {
        int njobs;
        long n0 = System.nanoTime();
        long remaining = timeoutMillis;
        do {
            if ((njobs = this.waitForManipulatorDecrement(remaining)) != 0) continue;
            return;
        } while ((remaining = (timeoutMillis * 1000000L + n0 - System.nanoTime() + 999999L) / 1000000L) > 0L);
        throw new IllegalStateException("Failed to synchronize internal jobs with [" + njobs + "] remaining after [" + timeoutMillis + "] milliseconds.");
    }

    public void scheduleManipulator(Runnable runnable) {
        CoreServiceImpl.INSTANCE.getExecutorService().submit(() -> {
            try {
                this.manipulatorStarted();
                runnable.run();
            }
            finally {
                this.manipulatorStopped();
            }
        });
        this.mainpulatorScheduled();
    }
}

