/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HexFormat;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecretsStore {
    private final byte[] masterKey;
    private final String kvc;
    private final Properties properties;
    private static final int GCM_IV_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;
    private static final String AES_GCM_ALGO = "AES-GCM";
    private static final SecureRandom secureRandom = new SecureRandom();

    private static String calcKVC(byte[] mk) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            SecretKeySpec cryptor = new SecretKeySpec(mk, "AES");
            cipher.init(1, cryptor);
            byte[] enc = cipher.doFinal(new byte[16]);
            return HexFormat.of().withUpperCase().formatHex(enc, 0, 3);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Secrets store is unable to calculate KVC of 32 byte AES-256 master key.", e);
        }
    }

    public SecretsStore(Properties properties, String masterKey) {
        Base64.Decoder dec = Base64.getDecoder();
        byte[] mk = dec.decode(masterKey);
        if (mk.length != 32) {
            throw new IllegalArgumentException("Secrets store must be initialized with a 32 byte AES-256 master key.");
        }
        this.properties = properties;
        this.masterKey = mk;
        this.kvc = SecretsStore.calcKVC(mk);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getKvc() {
        return this.kvc;
    }

    public byte[] diversifyMasterKey(String pid, String key) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(pid.getBytes("UTF-8"));
        md.update((byte)10);
        md.update(key.getBytes("UTF-8"));
        md.update((byte)10);
        byte[] diversifier = md.digest();
        for (int i = 0; i < 16; ++i) {
            int n = i;
            diversifier[n] = (byte)(diversifier[n] ^ diversifier[i + 16]);
        }
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        SecretKeySpec mk = new SecretKeySpec(this.masterKey, "AES");
        cipher.init(1, mk);
        return cipher.doFinal(diversifier, 0, 16);
    }

    public void encrypt(String pid, String key, String value) throws Exception {
        byte[] diversified = this.diversifyMasterKey(pid, key);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecretKeySpec cryptor = new SecretKeySpec(diversified, "AES");
        byte[] iv = new byte[12];
        secureRandom.nextBytes(iv);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)cryptor, gcmParameterSpec);
        byte[] encrypted = cipher.doFinal(value.getBytes("UTF-8"));
        Base64.Encoder b64Enc = Base64.getEncoder();
        String encryptedValue = "{AES-GCM," + b64Enc.encodeToString(iv) + "}" + b64Enc.encodeToString(encrypted);
        this.properties.setProperty(key, encryptedValue);
    }

    public String decrypt(String pid, String key) throws Exception {
        String encryptedValue = this.properties.getProperty(key);
        if (encryptedValue == null) {
            throw new IllegalArgumentException("There no value with key [" + key + "].");
        }
        if (!encryptedValue.startsWith("{")) {
            throw new IllegalArgumentException("Encyrpted value does not contain an encryption tag.");
        }
        int endOfTags = encryptedValue.indexOf(125, 1);
        if (endOfTags < 0) {
            throw new IllegalArgumentException("Encyrpted value does not contain the end of an encryption tag.");
        }
        String[] tags = encryptedValue.substring(1, endOfTags).split(",");
        String algo = tags[0];
        if (!AES_GCM_ALGO.equals(algo)) {
            throw new IllegalArgumentException("Encyrpted value contains encryption tag with unknown algorithm [" + algo + "].");
        }
        if (tags.length != 2) {
            throw new IllegalArgumentException("Encyrpted value contains encryption tag for algorithm [" + algo + "] with wrong number of arguments.");
        }
        Base64.Decoder b64Dec = Base64.getDecoder();
        byte[] iv = b64Dec.decode(tags[1]);
        byte[] encrypted = b64Dec.decode(encryptedValue.substring(endOfTags + 1));
        byte[] diversified = this.diversifyMasterKey(pid, key);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecretKeySpec cryptor = new SecretKeySpec(diversified, "AES");
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)cryptor, gcmParameterSpec);
        byte[] decrypted = cipher.doFinal(encrypted);
        return new String(decrypted, "UTF-8");
    }
}

