/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class OpensDirective
implements Serializable {
    private static final long serialVersionUID = -2324073488225704752L;
    private static final Pattern PACKAGE_REGEX = Pattern.compile("(?x)[a-z][a-z0-9_]*(\\.[a-z][a-z0-9_]*)*");
    private static final Pattern COMMA_SEPARATOR_REGEX = Pattern.compile("\\s*,\\s*");
    private final String sourceModule;
    private final String sourcePackage;
    private final String targetModule;

    protected OpensDirective(String sourceModule, String sourcePackage, String targetModule) {
        this.sourceModule = sourceModule;
        this.sourcePackage = sourcePackage;
        this.targetModule = targetModule;
    }

    public static OpensDirective of(String sourceModule, String sourcePackage, String targetModule) {
        if (!PACKAGE_REGEX.matcher(sourceModule).matches()) {
            throw new IllegalArgumentException("Source module [" + sourceModule + "] is not a valid module name.");
        }
        if (!PACKAGE_REGEX.matcher(sourcePackage).matches()) {
            throw new IllegalArgumentException("Source package [" + sourcePackage + "] is not a valid package name.");
        }
        if (!PACKAGE_REGEX.matcher(targetModule).matches()) {
            throw new IllegalArgumentException("Target module [" + targetModule + "] is not a valid module name.");
        }
        return new OpensDirective(sourceModule, sourcePackage, targetModule);
    }

    public static OpensDirective ofSpec(String spec) {
        int slash = spec.indexOf(47);
        int eqsign = spec.indexOf(61, slash + 1);
        if (slash < 0 || eqsign < 0) {
            throw new IllegalArgumentException("Opens spec [" + spec + "] does not cntain a slash and an equals sign.");
        }
        return OpensDirective.of(spec.substring(0, slash), spec.substring(slash + 1, eqsign), spec.substring(eqsign + 1));
    }

    public static List<OpensDirective> ofSpecList(String specList) {
        if (specList == null) {
            return List.of();
        }
        String stripped = specList.strip();
        if (stripped.isEmpty()) {
            return List.of();
        }
        String[] specs = COMMA_SEPARATOR_REGEX.split(stripped);
        ArrayList<OpensDirective> ret = new ArrayList<OpensDirective>(specs.length);
        for (String spec : specs) {
            if (spec.isEmpty()) continue;
            ret.add(OpensDirective.ofSpec(spec));
        }
        return ret;
    }

    public String getSourceModule() {
        return this.sourceModule;
    }

    public String getSourcePackage() {
        return this.sourcePackage;
    }

    public String getTargetModule() {
        return this.targetModule;
    }

    public String toString() {
        return this.sourceModule + "/" + this.sourcePackage + "=" + this.targetModule;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sourceModule == null ? 0 : this.sourceModule.hashCode());
        result = 31 * result + (this.sourcePackage == null ? 0 : this.sourcePackage.hashCode());
        result = 31 * result + (this.targetModule == null ? 0 : this.targetModule.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpensDirective other = (OpensDirective)obj;
        if (this.sourceModule == null ? other.sourceModule != null : !this.sourceModule.equals(other.sourceModule)) {
            return false;
        }
        if (this.sourcePackage == null ? other.sourcePackage != null : !this.sourcePackage.equals(other.sourcePackage)) {
            return false;
        }
        return !(this.targetModule == null ? other.targetModule != null : !this.targetModule.equals(other.targetModule));
    }
}

