/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.util.concurrent.atomic.AtomicBoolean;
import org.clazzes.svc.runner.Config;
import org.clazzes.svc.runner.CoreServiceImpl;
import org.clazzes.svc.runner.ServiceContextImpl;
import org.clazzes.svc.runner.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Thread thread;
        Thread mainThread = Setup.setup();
        AtomicBoolean keepWorking = new AtomicBoolean(true);
        int stopTimeout = Config.getIntProperty("svc.runner.stopTimeout", 10000);
        int keepaliveTimeout = Config.getIntProperty("svc.runner.keepaliveTimeout", 10000);
        ServiceContextImpl svcCtxt = new ServiceContextImpl();
        try {
            Config.registerSecurityProviders();
            svcCtxt.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                log.info("Shutdown hook caught exit signal...");
                Thread thread = mainThread;
                synchronized (thread) {
                    keepWorking.set(false);
                    mainThread.notify();
                    try {
                        mainThread.wait();
                        log.info("Shutdown hook detected finish of main thread.");
                        Runtime.getRuntime().halt(0);
                    }
                    catch (InterruptedException e) {
                        log.error("Shutdown hook interrupted while waiting for main thread.", (Throwable)e);
                    }
                }
            }));
            thread = mainThread;
            synchronized (thread) {
                while (keepWorking.get()) {
                    if (log.isDebugEnabled()) {
                        log.debug("KEEPALIVE: main thread.");
                    }
                    mainThread.wait(keepaliveTimeout);
                }
            }
            log.info("Main thread will stop components upon exit signal.");
            svcCtxt.stop(stopTimeout);
            svcCtxt.synchronize(stopTimeout);
            log.info("About to leave main thread.");
        }
        catch (Throwable e) {
            log.error("Caught unexpected exception in svc-runner main", e);
        }
        finally {
            CoreServiceImpl.destroyInstance();
        }
        log.info("Informing shutdown hook about end of main thread.");
        thread = mainThread;
        synchronized (thread) {
            mainThread.notify();
        }
        log.info("Leaving main thread.");
        System.exit(0);
    }
}

