/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ConfigPidInfo;
import org.clazzes.svc.api.ConfigWrapper;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ThrowableInfo;
import org.clazzes.svc.runner.Config;
import org.clazzes.svc.runner.ConfigurationFiles;
import org.clazzes.svc.runner.CoreServiceImpl;
import org.clazzes.svc.runner.HasContext;
import org.clazzes.svc.runner.ThrowableBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationEngineImpl
extends HasContext
implements ConfigurationEngine {
    private static final String WATCH_CONFIG_FOLDER_PROPERTY = "svc.runner.watchConfigFolder";
    static final Logger log = LoggerFactory.getLogger(ConfigurationEngineImpl.class);
    private final Path admPath;
    private final Path admPathOverride;
    private final Map<String, ConfigSet> configSetsByPid = new ConcurrentHashMap<String, ConfigSet>();
    private final Map<String, List<Consumer<ConfigWrapper>>> listeners = new ConcurrentHashMap<String, List<Consumer<ConfigWrapper>>>();
    private Future<?> scanFuture;

    public ConfigurationEngineImpl() {
        Path etcDir = Config.getEtcDir();
        if (etcDir == null) {
            log.info("svc-runner etc path not configured, will not read properties from adm.d folder.");
            this.admPath = null;
            this.admPathOverride = null;
        } else {
            this.admPath = etcDir.resolve("adm.d");
            log.info("Will scan *.yaml from folder [{}].", (Object)this.admPath);
            this.admPathOverride = etcDir.resolve("adm.d.override");
            log.info("Will scan *.yaml from folder [{}].", (Object)this.admPathOverride);
        }
    }

    void start(ServiceContext svcCtxt) {
        this.setContext(svcCtxt);
        try {
            this.loadAdmPathFiles();
        }
        catch (IOException e) {
            log.error("I/O error scanning [{}]", (Object)this.admPath, (Object)e);
        }
        boolean doWatch = Config.getBooleanProperty(WATCH_CONFIG_FOLDER_PROPERTY, false);
        if (doWatch) {
            this.scanAdmPath();
        }
    }

    public void stop() {
        if (this.scanFuture != null) {
            log.info("Intrerrupting scan of folder [{}].", (Object)this.admPath);
            this.scanFuture.cancel(true);
        }
        this.clearContext();
    }

    public void loadTestYaml(ServiceContext svcCtxt, InputStream is, String res) throws IOException {
        this.setContext(svcCtxt);
        log.info("Loading config from resource [{}] for unit test purposes.", (Object)res);
        this.loadYamlResource(is, res);
    }

    private void scanAdmPath() {
        this.scanFuture = CoreServiceImpl.INSTANCE.getExecutorService().submit(() -> {
            try (WatchService watcher = FileSystems.getDefault().newWatchService();){
                WatchKey key;
                log.info("Starting to watch folder [{}].", (Object)this.admPath);
                this.admPath.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                if (Files.isDirectory(this.admPathOverride, new LinkOption[0])) {
                    log.info("Starting to watch folder [{}].", (Object)this.admPathOverride);
                    this.admPathOverride.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                } else {
                    log.warn("Folder [{}] does not exist, not watching it.", (Object)this.admPathOverride);
                }
                while ((key = watcher.take()) != null) {
                    Path p;
                    Watchable patt0$temp = key.watchable();
                    if (!(patt0$temp instanceof Path)) {
                        log.warn("Watch key [{}] is not associated with a known folder.", (Object)key);
                        continue;
                    }
                    Path folder = p = (Path)patt0$temp;
                    HashSet<Path> changedYamls = new HashSet<Path>();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) {
                            log.warn("Watch key for folder [{}] reported overflow.", (Object)folder);
                            continue;
                        }
                        WatchEvent<?> ev = event;
                        Path filename = (Path)ev.context();
                        String fn = filename.getFileName().toString();
                        boolean isYaml = fn.endsWith(".yaml");
                        if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                            if (isYaml) {
                                log.warn("YAML file [{}] in folder [{}] has been deleted, affected configurations will disappear in next program run.", (Object)filename, (Object)folder);
                                continue;
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Non-YAML file [{}] in folder [{}] has been deleted.", (Object)filename, (Object)folder);
                            continue;
                        }
                        if (isYaml) {
                            Path yamlFile = folder.resolve(filename);
                            log.info("Received event [{}] for yaml file [{}].", kind, (Object)yamlFile);
                            changedYamls.add(yamlFile);
                            continue;
                        }
                        log.warn("Ignoring file [{}] in folder [{}], which is not *.yaml.", (Object)filename, (Object)folder);
                    }
                    for (Path yamlFile : changedYamls) {
                        this.loadAdmPathYamlFile(yamlFile);
                    }
                    if (key.reset()) continue;
                    log.warn("Watch key for folder [{}] became invalid, leaving watcher loop.", (Object)folder);
                    break;
                }
            }
            catch (InterruptedException e) {
                log.info("Leaving watcher for folder [{}].", (Object)this.admPath);
                if (log.isDebugEnabled()) {
                    log.debug("Watcher for folder [{}] interrupted exception", (Object)this.admPath, (Object)e);
                }
            }
            catch (Throwable e) {
                log.error("Error watching folder [{}]", (Object)this.admPath, (Object)e);
            }
        });
    }

    private void callListener(Consumer<ConfigWrapper> listener, String pid, ConfigSet configSet) {
        this.getContext().scheduleManipulator(() -> {
            try {
                log.info("Calling listener [{}] on PID {}", (Object)listener, (Object)pid);
                listener.accept(configSet.config);
            }
            catch (Throwable e) {
                ThrowableInfo ti = configSet.error(log, "Error calling listener [{}] on PID {}", listener, pid, e);
                this.getContext().getService(ComponentManager.class).ifPresent(cm -> cm.recordConfigException(ti));
            }
        });
    }

    private void callListeners(String pid, ConfigSet configSet) {
        List<Consumer<ConfigWrapper>> pidListeners = this.listeners.get(pid);
        if (pidListeners == null) {
            return;
        }
        for (Consumer<ConfigWrapper> listener : pidListeners) {
            this.callListener(listener, pid, configSet);
        }
    }

    private void loadYamlResource(InputStream is, String res) throws IOException {
        Map<String, Map<String, ?>> configs = ConfigurationFiles.readYaml(is, res);
        for (Map.Entry<String, Map<String, ?>> e : configs.entrySet()) {
            Map<String, ?> config;
            ConfigWrapper cw;
            ConfigSet configSet;
            String pid = e.getKey();
            ConfigSet old = this.configSetsByPid.put(pid, configSet = new ConfigSet(res, cw = new ConfigWrapper(pid, config = e.getValue())));
            if (old != null) {
                if (old.config.getContent().equals(config)) {
                    log.info("Config PID [{}] did not change, not calling listeners.", (Object)pid);
                    continue;
                }
                log.info("Config PID [{}] changed,calling listeners again.", (Object)pid);
            }
            this.callListeners(pid, configSet);
        }
    }

    private void loadAdmPathYamlFile(Path p) {
        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
            this.loadYamlResource(is, p.toString());
        }
        catch (IOException e) {
            log.error("Error reading yaml file [" + String.valueOf(p) + "]", (Throwable)e);
        }
    }

    private void loadAdmDirectory(Path dir) throws IOException {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            log.info("Scanning config folder [{}] for *.yaml file...", (Object)dir);
            AtomicInteger nyaml = new AtomicInteger();
            Files.newDirectoryStream(dir, "*.yaml").forEach(p -> {
                this.loadAdmPathYamlFile((Path)p);
                nyaml.incrementAndGet();
            });
            log.info("Loaded [{}] yaml files from config folder [{}].", (Object)nyaml, (Object)dir);
        } else {
            log.warn("Skipping config folder [{}], which is not a directory.", (Object)dir);
        }
    }

    private void loadAdmPathFiles() throws IOException {
        if (this.admPath != null) {
            this.loadAdmDirectory(this.admPath);
        }
        if (this.admPathOverride != null) {
            this.loadAdmDirectory(this.admPathOverride);
        }
    }

    public AutoCloseable listen(String pid, Consumer<ConfigWrapper> updated) {
        List pidListeners = this.listeners.computeIfAbsent(pid, k -> new CopyOnWriteArrayList());
        pidListeners.add(updated);
        ConfigSet configSet = this.configSetsByPid.get(pid);
        if (configSet != null) {
            this.callListener(updated, pid, configSet);
        }
        return () -> pidListeners.remove(updated);
    }

    public List<ConfigPidInfo> listPids() {
        HashSet<String> pids = new HashSet<String>();
        pids.addAll(this.configSetsByPid.keySet());
        pids.addAll(this.listeners.keySet());
        ArrayList sorted = new ArrayList(pids);
        Collections.sort(sorted);
        ArrayList<ConfigPidInfo> ret = new ArrayList<ConfigPidInfo>();
        for (String pid : sorted) {
            ConfigSet configSet = this.configSetsByPid.get(pid);
            List<Consumer<ConfigWrapper>> pidListeners = this.listeners.get(pid);
            ret.add(new ConfigPidInfo(pid, configSet == null ? null : Integer.valueOf(configSet.config.getContent().size()), pidListeners == null ? null : Integer.valueOf(pidListeners.size()), configSet == null ? null : configSet.location, configSet == null ? null : configSet.getThrowables()));
        }
        return ret;
    }

    public Optional<ConfigWrapper> getPid(String pid) {
        ConfigSet configSet = this.configSetsByPid.get(pid);
        if (configSet == null) {
            return Optional.empty();
        }
        return Optional.of(configSet.config);
    }

    private static final class ConfigSet
    extends ThrowableBucket {
        public final String location;
        public final ConfigWrapper config;

        public ConfigSet(String location, ConfigWrapper config) {
            this.location = location;
            this.config = config;
        }
    }
}

