/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.lang.module.ModuleDescriptor;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentState;
import org.clazzes.svc.api.ServicePriority;
import org.clazzes.svc.runner.ThrowableBucket;

public class ComponentHolder
extends ThrowableBucket
implements Comparable<ComponentHolder> {
    private final Component component;
    private final int priority;
    private ComponentState state;
    private Thread transitionThread;

    public ComponentHolder(Component component, int priority) {
        this.component = component;
        this.priority = priority;
        this.state = ComponentState.LOADED;
    }

    public ComponentHolder(Component component, ServicePriority priority) {
        this(component, priority != null ? priority.value() : 100);
    }

    public Component getComponent() {
        return this.component;
    }

    public String getClassName() {
        return this.component.getClass().getName();
    }

    public String getModuleName() {
        return this.component.getClass().getModule().getName();
    }

    public String getModuleNameAndVersion() {
        return this.component.getClass().getModule().getDescriptor().toNameAndVersion();
    }

    public Optional<ModuleDescriptor.Version> getModuleVersion() {
        return this.component.getClass().getModule().getDescriptor().version();
    }

    public int getPriority() {
        return this.priority;
    }

    public synchronized ComponentState getState() {
        return this.state;
    }

    protected void checkState(ComponentState target, ComponentState ... allowed) {
        for (ComponentState a : allowed) {
            if (this.state != a) continue;
            this.state = target;
            return;
        }
        throw new IllegalStateException("Cannot switch from state [" + String.valueOf(this.state) + "] to [" + String.valueOf(target) + "] (allowed source states are " + Arrays.toString(allowed) + ").");
    }

    public synchronized void starting(Thread thread) {
        this.checkState(ComponentState.STARTING, ComponentState.LOADED, ComponentState.STOPPED, ComponentState.STOP_FAILED);
        this.transitionThread = thread;
    }

    public synchronized void started() {
        if (this.state != ComponentState.COMMITTED) {
            this.checkState(ComponentState.STARTED, ComponentState.STARTING);
        }
        this.transitionThread = null;
        this.notifyAll();
    }

    public synchronized void startFailed() {
        this.checkState(ComponentState.START_FAILED, ComponentState.STARTING);
        this.transitionThread = null;
        this.notifyAll();
    }

    public synchronized void stopping(Thread thread) {
        this.checkState(ComponentState.STOPPING, ComponentState.STARTED, ComponentState.START_FAILED, ComponentState.COMMITTED, ComponentState.CONFIG_LISTENER_FAILED, ComponentState.SERVICE_LISTENER_FAILED);
        this.state = ComponentState.STOPPING;
        this.transitionThread = thread;
    }

    public synchronized void stopped() {
        this.checkState(ComponentState.STOPPED, ComponentState.STOPPING);
        this.transitionThread = null;
        this.notifyAll();
    }

    public synchronized void stopFailed() {
        this.checkState(ComponentState.STOP_FAILED, ComponentState.STOPPING);
        this.transitionThread = null;
        this.notifyAll();
    }

    public synchronized ComponentState stopTransition(long timeout, Consumer<String> callback) throws InterruptedException {
        if (this.transitionThread == null) {
            return this.state;
        }
        callback.accept("Stopping transition on [" + String.valueOf(this) + "].");
        this.transitionThread.interrupt();
        this.wait(timeout);
        callback.accept("Successfully stopped transition on [" + String.valueOf(this) + "].");
        return this.state;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        result = 31 * result + this.priority;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentHolder other = (ComponentHolder)obj;
        if (this.component == null ? other.component != null : !this.component.equals((Object)other.component)) {
            return false;
        }
        return this.priority == other.priority;
    }

    public static int compareVersion(Optional<ModuleDescriptor.Version> a, Optional<ModuleDescriptor.Version> b) {
        if (a.isPresent()) {
            if (b.isPresent()) {
                return a.get().compareTo(b.get());
            }
            return 1;
        }
        return b.isPresent() ? -1 : 0;
    }

    @Override
    public int compareTo(ComponentHolder o) {
        if (this.priority > o.getPriority()) {
            return 1;
        }
        if (this.priority < o.getPriority()) {
            return -1;
        }
        int ret = this.getModuleName().compareTo(o.getModuleName());
        if (ret != 0) {
            return ret;
        }
        ret = ComponentHolder.compareVersion(this.getModuleVersion(), o.getModuleVersion());
        if (ret != 0) {
            return ret;
        }
        return this.getClassName().compareTo(o.getClassName());
    }

    public String toString() {
        return "ComponentHolder [component=" + this.getModuleNameAndVersion() + "/" + this.getClassName() + ", priority=" + this.priority + ", state=" + String.valueOf(this.getState()) + "]";
    }
}

