/***********************************************************
 *
 * Service Runner framework runner using commons-daemon
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.runner;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <p>This class is used to start an svc-runner instance
 * during unit tests.
 * </p>
 */
public class UnitTestSupport implements AutoCloseable {

    private static final Logger log = LoggerFactory.getLogger(UnitTestSupport.class);

    private final ServiceContextImpl serviceContext;

    static {
        try {
            Config.registerSecurityProviders();
        } catch (Exception e) {
            log.error("Error registering security providers in svc-runenr Unit Test support.",e);
        }
    }

    protected UnitTestSupport(ServiceContextImpl serviceContext) {
        this.serviceContext = serviceContext;
    }

    public ServiceContextImpl getServiceContext() {
        return this.serviceContext;
    }

    public static UnitTestSupport before(String configYaml) throws Exception {

        return before(new ByteArrayInputStream(configYaml.getBytes(StandardCharsets.UTF_8)),"before-parameter");
    }

    public static UnitTestSupport before(InputStream configYaml, String configResource) throws Exception {

        ServiceContextImpl serviceContext = new ServiceContextImpl();

        serviceContext.startForTest(configYaml,configResource);

        return new UnitTestSupport(serviceContext);
    }

    @Override
    public void close() throws Exception {

        int stopTimeout = Config.getIntProperty(Setup.STOP_TIMEOUT_PROPERTY,10000);

        this.serviceContext.stop(stopTimeout);
    }
}
