/***********************************************************
*
* Service Runner of the clazzes.org project
* https://www.clazzes.org
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
***********************************************************/

package org.clazzes.svc.runner;

import java.util.function.Supplier;

import org.clazzes.svc.api.CoreService;

public class SecretSupplier implements Supplier<String> {

    private final String pid;
    private final String scheme;
    private final String key;

    public SecretSupplier(String pid, String scheme, String key) {
        this.pid = pid;
        this.scheme = scheme;
        this.key = key;
    }

    @Override
    public String get() {

        CoreService coreService = CoreServiceImpl.provider();
        return coreService.getSecret(this.pid,this.scheme,this.key);
    }

    public String getPid() {
        return this.pid;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public String toString() {
        return "SecretSupplier[" + this.scheme + ":" + this.key + "(" + this.pid + ")]";
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((this.pid == null) ? 0 : this.pid.hashCode());
        result = prime * result + ((this.scheme == null) ? 0 : this.scheme.hashCode());
        result = prime * result + ((this.key == null) ? 0 : this.key.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SecretSupplier other = (SecretSupplier) obj;
        if (this.pid == null) {
            if (other.pid != null)
                return false;
        } else if (!pid.equals(other.pid))
            return false;
        if (this.scheme == null) {
            if (other.scheme != null)
                return false;
        } else if (!this.scheme.equals(other.scheme))
            return false;
        if (this.key == null) {
            if (other.key != null)
                return false;
        } else if (!this.key.equals(other.key))
            return false;
        return true;
    }

}
