/**
 * $Id$
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.clazzes.svc.runner;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

/**
 * Command line tool used to manage config files.
 */
public class ManageConfigs {

    static public void usage() {

        System.err.println("usage:");
        System.err.println("  ManageConfigs -to-yaml <cfg-file> [<cfg-file> ...]");
        System.exit(1);
    }

    /**
     * Main program for managing config files.
     *
     * @param args The program arguments
     */
    public static void main(String[] args) throws Exception {

        int iarg = 0;

        if (args.length < 1) {
            usage();
        }

        String command = args[iarg++];

        if ("-to-yaml".equals(command)) {
            if (iarg == args.length) {
                usage();
            }

            Map<String,Map<String,?>> configs = new HashMap<String,Map<String,?>>();

            for (;iarg<args.length;++iarg) {

                Path filename = Path.of(args[iarg]);

                Map<String,?> config = ConfigurationFiles.readCfgFile(filename);

                String pid = ConfigurationFiles.getServicePid(config);

                configs.put(pid,config);
            }

            ConfigurationFiles.writeYaml(System.out,"stdout", configs);
        }
        else {
            System.err.println("Invalid command ["+command+"].");
            usage();
        }

    }

}
