/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.module.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.clazzes.svc.module.api.PluginDescription;
import org.clazzes.svc.module.api.PluginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginServiceImpl
implements PluginService {
    private static final Logger log = LoggerFactory.getLogger(PluginServiceImpl.class);
    private final Map<String, List<PluginDescription>> pluginsByProject = new ConcurrentHashMap<String, List<PluginDescription>>();
    private static final Comparator<PluginDescription> PC = new Comparator<PluginDescription>(){

        @Override
        public int compare(PluginDescription o1, PluginDescription o2) {
            int r = o1.getPriority() == null ? (o2.getPriority() == null ? 0 : 1) : (o2.getPriority() == null ? -1 : o2.getPriority().compareTo(o1.getPriority()));
            if (r != 0) {
                return r;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pluginBound(String key, PluginDescription plugin) {
        String project = plugin.getProject();
        List plugins = this.pluginsByProject.computeIfAbsent(project, k -> new ArrayList());
        log.info("Bound [{}] for key [{}]", (Object)plugin, (Object)key);
        List list = plugins;
        synchronized (list) {
            int i = Collections.binarySearch(plugins, plugin, PC);
            if (i >= 0) {
                throw new IllegalArgumentException("Duplicate registration of plugin for project [" + project + "], name [" + plugin.getName() + "] and priority [" + plugin.getPriority() + "]");
            }
            int insertion = -i - 1;
            if (log.isDebugEnabled()) {
                log.debug("Inserted [{}] at index [{}]", (Object)plugin, (Object)insertion);
            }
            plugins.add(insertion, plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pluginUnbound(String key, PluginDescription plugin) {
        String project = plugin.getProject();
        List<PluginDescription> plugins = this.pluginsByProject.get(project);
        if (plugins == null) {
            return;
        }
        log.info("Unbound [{}] for key [{}]", (Object)plugin, (Object)key);
        List<PluginDescription> list = plugins;
        synchronized (list) {
            int i = Collections.binarySearch(plugins, plugin, PC);
            if (i >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Removing [{}] at index [{}]", (Object)plugin, (Object)i);
                }
                plugins.remove(i);
            } else {
                log.warn("Plugin [{}] not found.", (Object)plugin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PluginDescription> getAllForProject(String project) {
        List<PluginDescription> plugins = this.pluginsByProject.get(project);
        if (plugins == null) {
            return List.of();
        }
        List<PluginDescription> list = plugins;
        synchronized (list) {
            return new ArrayList<PluginDescription>(plugins);
        }
    }
}

