/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.module.api;

import org.clazzes.svc.module.api.PluginDescription;

public class PluginDescriptionImpl
implements PluginDescription {
    private final String name;
    private final String project;
    private final String feature;
    private final String url;
    private final String mainClass;
    private final String cssUrl;
    private final Integer priority;

    protected PluginDescriptionImpl(String name, String project, String feature, String url, String mainClass, String cssUrl, Integer priority) {
        this.name = name;
        this.url = url;
        this.mainClass = mainClass;
        this.feature = feature;
        this.cssUrl = cssUrl;
        this.project = project;
        this.priority = priority;
    }

    public static PluginDescription ofRootApplication(String name, String url) {
        return PluginDescriptionImpl.ofRootApplication(name, url, null);
    }

    public static PluginDescription ofRootApplication(String name, String url, Integer priority) {
        return new PluginDescriptionImpl(name, "root", "Application", url, "Main", null, priority);
    }

    public static PluginDescription ofProjectPlugin(String name, String project, String feature, String url, String cssUrl, Integer priority) {
        return new PluginDescriptionImpl(name, project, feature, url, "Plugin", cssUrl, priority);
    }

    public static PluginDescription ofProjectPlugin(String name, String project, String feature, String url, String cssUrl) {
        return PluginDescriptionImpl.ofProjectPlugin(name, project, feature, url, cssUrl, null);
    }

    public static PluginDescription of(String name, String project, String feature, String url, String mainClass, String cssUrl, Integer priority) {
        return new PluginDescriptionImpl(name, project, feature, url, mainClass, cssUrl, priority);
    }

    public static PluginDescription of(String name, String project, String feature, String url, String mainClass, String cssUrl) {
        return PluginDescriptionImpl.of(name, project, feature, url, mainClass, cssUrl, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProject() {
        return this.project;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getMainClass() {
        return this.mainClass;
    }

    @Override
    public String getFeature() {
        return this.feature;
    }

    @Override
    public String getCssUrl() {
        return this.cssUrl;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    public String toString() {
        return "PluginDescriptionImpl [name=" + this.name + ", project=" + this.project + ", feature=" + this.feature + ", url=" + this.url + ", mainClass=" + this.mainClass + ", cssUrl=" + this.cssUrl + ", priority=" + this.priority + "]";
    }
}

