/***********************************************************
 *
 * SVC module API of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

 package org.clazzes.svc.module.impl;

import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ComponentSupport;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.svc.module.api.PluginDescription;
import org.clazzes.svc.module.api.PluginService;

public class SvcModuleApiComponent extends ComponentSupport implements Component {

    private final PluginServiceImpl pluginService = new PluginServiceImpl();

    @Override
    public void start(ServiceContext context) throws Exception {

        ServiceRegistry registry = context.getService(ServiceRegistry.class).get();

        this.addListener(registry.listenAll(PluginDescription.class,
           this.pluginService::pluginBound,this.pluginService::pluginUnbound));

        context.getService(ComponentManager.class).ifPresent(ComponentManager::commit);

        this.addService(registry,"svc-module-api",PluginService.class,this.pluginService);
    }

    @Override
    public void stop(ServiceContext context) throws Exception {
        ServiceRegistry registry = context.getService(ServiceRegistry.class).get();

        this.closeAllListeners();
        this.removeAllServices(registry);
    }


}
