/***********************************************************
 *
 * SVC module API of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.module.api;

/**
 * An implementation of {@link PluginDescription}.
 */
public class PluginDescriptionImpl implements PluginDescription {

    private final String name;
    private final String project;
    private final String feature;
    private final String url;
    private final String mainClass;
    private final String cssUrl;
    private final Integer priority;

    protected PluginDescriptionImpl(String name, String project, String feature, String url, String mainClass,
            String cssUrl, Integer priority) {
        this.name = name;
        this.url = url;
        this.mainClass = mainClass;
        this.feature = feature;
        this.cssUrl = cssUrl;
        this.project = project;
        this.priority = priority;
    }

    public static PluginDescription ofRootApplication(String name, String url) {

        return ofRootApplication(name,url,null);
    }

    public static PluginDescription ofRootApplication(String name, String url, Integer priority) {

        return new PluginDescriptionImpl(name,"root","Application",url,"Main",null,priority);
    }

    public static PluginDescription ofProjectPlugin(String name,String project,String feature,String url, String cssUrl, Integer priority) {

        return new PluginDescriptionImpl(name,project,feature,url,"Plugin",cssUrl,priority);
    }

    public static PluginDescription ofProjectPlugin(String name,String project,String feature,String url, String cssUrl) {

        return ofProjectPlugin(name,project,feature,url,cssUrl,null);
    }

    public static PluginDescription of(String name, String project, String feature, String url, String mainClass,
            String cssUrl, Integer priority) {

        return new PluginDescriptionImpl(name,project,feature,url,mainClass,cssUrl,priority);
    }

    public static PluginDescription of(String name, String project, String feature, String url, String mainClass,
            String cssUrl) {

        return of(name,project,feature,url,mainClass,cssUrl,null);
    }

    public String getName() {
        return this.name;
    }

    public String getProject() {
        return project;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getFeature() {
        return this.feature;
    }

    public String getCssUrl() {
        return this.cssUrl;
    }

    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public String toString() {
        return "PluginDescriptionImpl [name=" + this.name +
               ", project=" + this.project +
               ", feature=" + this.feature +
               ", url=" + this.url +
               ", mainClass=" + this.mainClass +
               ", cssUrl=" + this.cssUrl +
               ", priority=" + this.priority + "]";
    }

}
