/***********************************************************
 * $Id$
 *
 * DOJO module API of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.module.api;


/** Implementors of this service interface describe the properties of a plugin (written in Dojo) providing
 *  functionality of a defined kind for certain kinds of shapes.
 */
public interface PluginDescription {

	/**
	 * Returns the name of the plugin.
	 * The name is a unique identifier possibly show to users.
	 *
	 * @return the name of the plugin as described
	 */
	public String getName();

	/**
	 * Returns the name of the target project, which is extended by this plugin.
	 * <code>root</code> is used for applications.
	 *
	 * @return The target project, which is extended by this plugin.
	 */
	public String getProject();

	/**
	 * @return the path under which the code of this particular plugin is installed
	 */
	public String getUrl();

	/**
	 * Returns the name of the main class of this plugin
	 * relative to the result of {@link #getUrl()}. The name is usually set set to the default
	 * name <code>Plugin</code>.
	 *
	 * @return the name of the main class
	 */
	public String getMainClass();

	/**
	 * Returns the name of the feature provided by this plugin.
	 * <code>Application</code> is used for applications.
	 *
	 * @return the name of the feature provided by this plugin
	 */
	public String getFeature();

	/**
	 * Returns the URL from which a CSS needed by the plugin at hand is to be loaded.
	 *
	 * @return the URL from which a CSS needed by the plugin at hand is to be loaded or
     *         <code>null</code> if no CSS needs to be loaded.
	 */
	public String getCssUrl();

	/**
	 * @return The optional priority, which is used to group the plugins.
	 */
	public Integer getPriority();
}


