/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.xerces.dom.DocumentImpl;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfMetaDom;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.OdfSettingsDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.rdfa.BookmarkRDFMetadataExtractor;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfAttribute;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileSaxHandler;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfNamespace;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;
import org.odftoolkit.odfdom.pkg.manifest.OdfManifestDom;
import org.odftoolkit.odfdom.pkg.rdfa.DOMRDFaParser;
import org.odftoolkit.odfdom.pkg.rdfa.JenaSink;
import org.odftoolkit.odfdom.pkg.rdfa.MultiContentHandler;
import org.odftoolkit.odfdom.pkg.rdfa.SAXRDFaParser;
import org.odftoolkit.odfdom.pkg.rdfa.Util;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class OdfFileDom
extends DocumentImpl
implements NamespaceContext {
    private static final long serialVersionUID = 766167617530147000L;
    protected String mPackagePath;
    protected OdfPackageDocument mPackageDocument;
    protected OdfPackage mPackage;
    protected XPath mXPath;
    protected Map<String, String> mUriByPrefix;
    protected Map<String, String> mPrefixByUri;
    protected Map<String, Set<String>> mDuplicatePrefixesByUri;
    protected Map<Node, Model> inCententMetadataCache;
    protected JenaSink sink;

    protected OdfFileDom(OdfPackageDocument packageDocument, String packagePath) {
        super(false);
        if (packageDocument != null && packagePath != null) {
            this.mPackageDocument = packageDocument;
            this.mPackage = packageDocument.getPackage();
            this.mPackagePath = packagePath;
            this.mUriByPrefix = new HashMap<String, String>();
            this.mPrefixByUri = new HashMap<String, String>();
            this.mDuplicatePrefixesByUri = new HashMap<String, Set<String>>();
            this.inCententMetadataCache = new IdentityHashMap<Node, Model>();
            try {
                this.initialize();
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                Logger.getLogger(OdfFileDom.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            throw new IllegalArgumentException("Arguments are not allowed to be NULL for OdfFileDom constructor!");
        }
        this.addDomToCache(this.mPackage, packagePath);
    }

    protected OdfFileDom(OdfPackage pkg, String packagePath) {
        super(false);
        if (pkg != null && packagePath != null) {
            this.mPackageDocument = null;
            this.mPackage = pkg;
            this.mPackagePath = packagePath;
            this.mUriByPrefix = new HashMap<String, String>();
            this.mPrefixByUri = new HashMap<String, String>();
            this.mDuplicatePrefixesByUri = new HashMap<String, Set<String>>();
            this.inCententMetadataCache = new HashMap<Node, Model>();
            try {
                this.initialize();
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                Logger.getLogger(OdfFileDom.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            throw new IllegalArgumentException("Arguments are not allowed to be NULL for OdfFileDom constructor!");
        }
        this.addDomToCache(this.mPackage, packagePath);
    }

    private void addDomToCache(OdfPackage pkg, String internalPath) {
        pkg.cacheDom(this, internalPath);
    }

    static OdfFileDom newFileDom(OdfPackageDocument packageDocument, String packagePath) {
        OdfFileDom newFileDom = null;
        Document existingDom = packageDocument.getPackage().getCachedDom(packagePath);
        if (existingDom == null) {
            newFileDom = packagePath.equals("content.xml") || packagePath.endsWith("/content.xml") ? new OdfContentDom((OdfSchemaDocument)packageDocument, packagePath) : (packagePath.equals("styles.xml") || packagePath.endsWith("/styles.xml") ? new OdfStylesDom((OdfSchemaDocument)packageDocument, packagePath) : (packagePath.equals("meta.xml") || packagePath.endsWith("/meta.xml") ? new OdfMetaDom((OdfSchemaDocument)packageDocument, packagePath) : (packagePath.equals("settings.xml") || packagePath.endsWith("/settings.xml") ? new OdfSettingsDom((OdfSchemaDocument)packageDocument, packagePath) : (packagePath.equals("META-INF/manifest.xml") || packagePath.endsWith("/META-INF/manifest.xml") ? new OdfManifestDom((OdfSchemaDocument)packageDocument, packagePath) : new OdfFileDom(packageDocument, packagePath)))));
        } else if (existingDom instanceof OdfFileDom) {
            newFileDom = (OdfFileDom)existingDom;
        }
        return newFileDom;
    }

    public static OdfFileDom newFileDom(OdfPackage pkg, String packagePath) {
        OdfFileDom newFileDom = null;
        Document existingDom = pkg.getCachedDom(packagePath);
        if (existingDom == null) {
            newFileDom = packagePath.equals("META-INF/manifest.xml") || packagePath.endsWith("/META-INF/manifest.xml") ? new OdfManifestDom(pkg, packagePath) : new OdfFileDom(pkg, packagePath);
        } else if (existingDom instanceof OdfFileDom) {
            newFileDom = (OdfFileDom)existingDom;
        }
        return newFileDom;
    }

    protected void initialize() throws SAXException, IOException, ParserConfigurationException {
        this.initialize(new OdfFileSaxHandler(this), this);
    }

    protected void initialize(DefaultHandler handler, OdfFileDom dom) throws SAXException, IOException, ParserConfigurationException {
        InputStream fileStream = null;
        try {
            fileStream = this.mPackage.getInputStream(this.mPackagePath);
            if (fileStream != null) {
                XMLReader xmlReader = this.mPackage.getXMLReader();
                String baseUri = Util.getRDFBaseUri(this.mPackage.getBaseURI(), this.mPackagePath);
                if (handler instanceof OdfFileSaxHandler) {
                    OdfFileSaxHandler odfSaxHandler = (OdfFileSaxHandler)handler;
                    this.sink = new JenaSink(this);
                    odfSaxHandler.setSink(this.sink);
                    SAXRDFaParser rdfa = SAXRDFaParser.createInstance(this.sink);
                    rdfa.setBase(baseUri);
                    MultiContentHandler multi = new MultiContentHandler(odfSaxHandler, rdfa);
                    xmlReader.setContentHandler(multi);
                } else {
                    xmlReader.setContentHandler(handler);
                }
                InputSource xmlSource = new InputSource(fileStream);
                xmlReader.parse(xmlSource);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(OdfFileDom.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (IOException iex) {
                Logger.getLogger(OdfFileDom.class.getName()).log(Level.SEVERE, null, iex);
            }
        }
    }

    public OdfPackageDocument getDocument() {
        return this.mPackageDocument;
    }

    public String getPackagePath() {
        return this.mPackagePath;
    }

    public OdfElement getRootElement() {
        return (OdfElement)this.getDocumentElement();
    }

    @Override
    public OdfElement createElement(String name) throws DOMException {
        return this.createElementNS(OdfName.newName(name));
    }

    @Override
    public OdfElement createElementNS(String nsuri, String qname) throws DOMException {
        return this.createElementNS(OdfName.newName(nsuri, qname));
    }

    public OdfElement createElementNS(OdfName name) throws DOMException {
        return OdfXMLFactory.newOdfElement(this, name);
    }

    @Override
    public OdfAttribute createAttribute(String name) throws DOMException {
        return this.createAttributeNS(OdfName.newName(name));
    }

    @Override
    public OdfAttribute createAttributeNS(String nsuri, String qname) throws DOMException {
        return this.createAttributeNS(OdfName.newName(nsuri, qname));
    }

    public OdfAttribute createAttributeNS(OdfName name) throws DOMException {
        return OdfXMLFactory.newOdfAttribute(this, name);
    }

    public <T extends OdfElement> T newOdfElement(Class<T> clazz) {
        try {
            Field fname = clazz.getField("ELEMENT_NAME");
            OdfName name = (OdfName)fname.get(null);
            return (T)this.createElementNS(name);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            return null;
        }
    }

    @Override
    public String toString() {
        return ((OdfElement)this.getDocumentElement()).toString();
    }

    public XPath getXPath() {
        if (this.mXPath == null) {
            this.mXPath = XPathFactory.newInstance().newXPath();
        }
        return this.mXPath;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String nsURI = null;
        nsURI = this.mUriByPrefix.get(prefix);
        if (nsURI == null) {
            Set<String> urisWithDuplicatePrefixes = this.mDuplicatePrefixesByUri.keySet();
            for (String aURI : urisWithDuplicatePrefixes) {
                Set<String> prefixes = this.mDuplicatePrefixesByUri.get(aURI);
                if (!prefixes.contains(prefix)) continue;
                nsURI = aURI;
                break;
            }
        }
        if (nsURI == null) {
            nsURI = "";
        }
        return nsURI;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.mPrefixByUri.get(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        String givenPrefix;
        Set<String> prefixes = this.mDuplicatePrefixesByUri.get(namespaceURI);
        if (prefixes == null) {
            prefixes = new HashSet<String>();
        }
        if ((givenPrefix = this.mPrefixByUri.get(namespaceURI)) != null) {
            prefixes.add(givenPrefix);
        }
        return prefixes.iterator();
    }

    Map<String, String> getMapNamespacePrefixByUri() {
        return this.mPrefixByUri;
    }

    public OdfNamespace setNamespace(String prefix, String uri) {
        OdfNamespace newNamespace = null;
        String existingPrefix = this.mPrefixByUri.get(uri);
        if (existingPrefix != null) {
            newNamespace = OdfNamespace.newNamespace(existingPrefix, uri);
            Set<String> prefixes = this.mDuplicatePrefixesByUri.get(uri);
            if (prefixes == null) {
                prefixes = new HashSet<String>();
                this.mDuplicatePrefixesByUri.put(uri, prefixes);
            }
            prefixes.add((String)prefix);
        } else {
            String existingURI = this.mUriByPrefix.get(prefix);
            if (existingURI != null && !existingURI.equals(uri)) {
                int i = 1;
                do {
                    int suffixStart;
                    if ((suffixStart = ((String)prefix).lastIndexOf("__")) != -1) {
                        prefix = ((String)prefix).substring(0, suffixStart);
                    }
                    prefix = (String)prefix + "__" + i;
                    ++i;
                } while ((existingURI = this.mUriByPrefix.get(prefix)) != null && !existingURI.equals(uri));
            }
            newNamespace = OdfNamespace.newNamespace((String)prefix, uri);
            this.mPrefixByUri.put(uri, (String)prefix);
            this.mUriByPrefix.put((String)prefix, uri);
        }
        OdfElement root = this.getRootElement();
        if (root != null) {
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)prefix, uri);
        }
        return newNamespace;
    }

    public OdfNamespace setNamespace(NamespaceName name) {
        return this.setNamespace(name.getPrefix(), name.getUri());
    }

    public Map<Node, Model> getInContentMetadataCache() {
        return this.inCententMetadataCache;
    }

    public void updateInContentMetadataCache(Node node) {
        this.getInContentMetadataCache().remove(node);
        DOMRDFaParser parser = DOMRDFaParser.createInstance(this.sink);
        String baseUri = Util.getRDFBaseUri(this.mPackage.getBaseURI(), this.mPackagePath);
        parser.setBase(baseUri);
        parser.parse(node);
    }

    public Model getBookmarkRDFMetadata() {
        return BookmarkRDFMetadataExtractor.newBookmarkTextExtractor().getBookmarkRDFMetadata(this);
    }

    public JenaSink getSink() {
        return this.sink;
    }

    public String getNextMarkupId() {
        return this.getDocument().getPackage().getNextMarkupId();
    }
}

