/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.search;

import java.util.ArrayList;
import java.util.HashMap;
import org.odftoolkit.odfdom.incubator.search.Selection;
import org.odftoolkit.odfdom.incubator.search.TextSelection;
import org.odftoolkit.odfdom.pkg.OdfElement;

public class SelectionManager {
    private HashMap<OdfElement, ArrayList<Selection>> repository = new HashMap();

    public void registerItem(Selection item) {
        OdfElement element = item.getElement();
        if (this.repository.containsKey(element)) {
            int i;
            ArrayList<Selection> selections = this.repository.get(element);
            for (i = 0; i < selections.size(); ++i) {
                if (selections.get(i).getIndex() <= item.getIndex()) continue;
                selections.add(i, item);
                break;
            }
            if (i == selections.size()) {
                selections.add(item);
            }
        } else {
            ArrayList<Selection> al = new ArrayList<Selection>();
            al.add(item);
            this.repository.put(element, al);
        }
    }

    public void refreshAfterCut(Selection cutItem) {
        OdfElement element = cutItem.getElement();
        if (this.repository.containsKey(element)) {
            ArrayList<Selection> selections = this.repository.get(element);
            for (int i = 0; i < selections.size(); ++i) {
                if (selections.get(i).getIndex() <= cutItem.getIndex()) continue;
                selections.get(i).refreshAfterFrontalDelete(cutItem);
            }
        }
    }

    public void refreshAfterPasteAtFrontOf(Selection item, Selection positionItem) {
        OdfElement element = positionItem.getElement();
        if (this.repository.containsKey(element)) {
            ArrayList<Selection> selections = this.repository.get(element);
            for (int i = 0; i < selections.size(); ++i) {
                if (selections.get(i).getIndex() < positionItem.getIndex()) continue;
                selections.get(i).refreshAfterFrontalInsert(item);
            }
        }
    }

    public void refreshAfterPasteAtEndOf(Selection item, Selection positionItem) {
        OdfElement element = positionItem.getElement();
        int positionIndex = positionItem instanceof TextSelection ? positionItem.getIndex() + ((TextSelection)positionItem).getText().length() : positionItem.getIndex();
        if (this.repository.containsKey(element)) {
            ArrayList<Selection> selections = this.repository.get(element);
            for (int i = 0; i < selections.size(); ++i) {
                if (selections.get(i).getIndex() < positionIndex) continue;
                selections.get(i).refreshAfterFrontalInsert(item);
            }
        }
    }

    public void unregisterItem(Selection item) {
        OdfElement element = item.getElement();
        if (this.repository.containsKey(element)) {
            ArrayList<Selection> selections = this.repository.get(element);
            selections.remove(item);
        }
    }

    public void unregisterAll() {
        this.repository.clear();
    }

    public void refresh(OdfElement containerElement, int offset, int positionIndex) {
        if (this.repository.containsKey(containerElement)) {
            ArrayList<Selection> selections = this.repository.get(containerElement);
            for (int i = 0; i < selections.size(); ++i) {
                if (selections.get(i).getIndex() < positionIndex) continue;
                selections.get(i).refresh(offset);
            }
        }
    }
}

