/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.search;

import java.util.Iterator;
import org.odftoolkit.odfdom.incubator.search.Selection;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;

public abstract class Navigation<T extends Selection>
implements Iterator<T> {
    @Override
    public abstract boolean hasNext();

    public abstract OdfElement getElement();

    @Override
    public abstract T next();

    public abstract boolean match(Node var1);

    protected Node getNextMatchElement(Node startpoint) {
        Node matchedNode = null;
        matchedNode = this.traverseTree(startpoint);
        for (Node currentpoint = startpoint; matchedNode == null && currentpoint != null; currentpoint = currentpoint.getParentNode()) {
            Node sibling = currentpoint.getNextSibling();
            if (sibling != null && (sibling.getNodeType() == 3 || sibling.getNodeType() == 1) && this.match(sibling)) {
                matchedNode = sibling;
            }
            while (sibling != null && matchedNode == null) {
                if (sibling.getNodeType() == 3 || sibling.getNodeType() == 1) {
                    matchedNode = this.traverseTree(sibling);
                }
                if ((sibling = sibling.getNextSibling()) == null || !this.match(sibling)) continue;
                matchedNode = sibling;
            }
        }
        return matchedNode;
    }

    protected Node getNextMatchElementInTree(Node startpoint, Node root) {
        Node matchedNode = null;
        matchedNode = this.traverseTree(startpoint);
        for (Node currentpoint = startpoint; matchedNode == null && currentpoint != root; currentpoint = currentpoint.getParentNode()) {
            Node sibling = currentpoint.getNextSibling();
            if (sibling != null && (sibling.getNodeType() == 3 || sibling.getNodeType() == 1) && this.match(sibling)) {
                matchedNode = sibling;
            }
            while (sibling != null && matchedNode == null) {
                if (sibling.getNodeType() == 3 || sibling.getNodeType() == 1) {
                    matchedNode = this.traverseTree(sibling);
                }
                if ((sibling = sibling.getNextSibling()) == null || !this.match(sibling)) continue;
                matchedNode = sibling;
            }
        }
        return matchedNode;
    }

    private Node traverseTree(Node root) {
        Node matchedNode = null;
        if (root == null) {
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3 && node.getNodeType() != 1) continue;
            if (this.match(node)) {
                matchedNode = node;
                break;
            }
            matchedNode = this.traverseTree(node);
            if (matchedNode != null) break;
        }
        return matchedNode;
    }
}

