/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.number;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.number.NumberFractionElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberScientificNumberElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMapElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class OdfNumberStyle
extends NumberNumberStyleElement {
    public OdfNumberStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfNumberStyle(OdfFileDom ownerDoc, String format, String styleName) {
        super(ownerDoc);
        this.setStyleNameAttribute(styleName);
        this.setFormat(format);
    }

    private String quoteTextContent(String text) {
        Pattern p = Pattern.compile("[MDYHMSE#0,.]+");
        Matcher m4 = p.matcher((CharSequence)text);
        if (m4.find()) {
            text = "\"" + (String)text + "\"";
        }
        return text;
    }

    @Override
    public String getFormat(boolean caps) {
        Object mappedResult = "";
        Object result = "";
        for (Node m4 = this.getFirstChild(); m4 != null; m4 = m4.getNextSibling()) {
            Integer exp;
            if (m4 instanceof NumberNumberElement) {
                result = (String)result + this.getNumberFormat();
                continue;
            }
            if (m4 instanceof NumberTextElement) {
                String textcontent = m4.getTextContent();
                if (textcontent == null || textcontent.length() == 0) {
                    textcontent = " ";
                }
                result = (String)result + this.quoteTextContent(textcontent);
                continue;
            }
            if (m4 instanceof StyleTextPropertiesElement) {
                result = (String)result + this.getColorFromElement((StyleTextPropertiesElement)m4);
                continue;
            }
            if (m4 instanceof StyleMapElement) {
                mappedResult = (String)mappedResult + this.getMapping((StyleMapElement)m4);
                mappedResult = (String)mappedResult + ";";
                continue;
            }
            if (m4 instanceof NumberFractionElement) {
                Integer numeratorCount;
                NumberFractionElement f = (NumberFractionElement)m4;
                Integer digitCount = f.getNumberMinIntegerDigitsAttribute();
                if (digitCount != null) {
                    if (digitCount == 0) {
                        result = (String)result + "#";
                    } else {
                        while ((digitCount = Integer.valueOf(digitCount - 1)) >= 0) {
                            result = (String)result + "0";
                        }
                    }
                    result = (String)result + " ";
                }
                if ((numeratorCount = f.getNumberMinNumeratorDigitsAttribute()) != null) {
                    while ((numeratorCount = Integer.valueOf(numeratorCount - 1)) >= 0) {
                        result = (String)result + "?";
                    }
                } else {
                    result = (String)result + "?";
                }
                result = (String)result + "/";
                Integer denominatorCount = f.getNumberMinDenominatorDigitsAttribute();
                if (denominatorCount != null) {
                    while ((denominatorCount = Integer.valueOf(denominatorCount - 1)) >= 0) {
                        result = (String)result + "?";
                    }
                    continue;
                }
                result = (String)result + "?";
                continue;
            }
            if (!(m4 instanceof NumberScientificNumberElement)) continue;
            NumberScientificNumberElement s2 = (NumberScientificNumberElement)m4;
            Boolean isGroup = s2.getNumberGroupingAttribute();
            Integer digits = s2.getNumberMinIntegerDigitsAttribute();
            int digitCount = digits == null ? 0 : digits;
            for (int digit = 0; digit < digitCount; ++digit) {
                result = (String)result + "0";
            }
            Integer places = s2.getNumberDecimalPlacesAttribute();
            if (places != null) {
                result = (String)result + ".";
                int placeCount = places;
                while (--placeCount >= 0) {
                    result = (String)result + "0";
                }
            }
            result = (String)result + "E";
            if (isGroup != null && isGroup.booleanValue()) {
                if (digitCount < 4) {
                    String fill = "#,###";
                    result = fill.substring(0, 5 - digitCount) + (String)result;
                } else {
                    result = ((String)result).substring(0, digitCount - 3) + "," + ((String)result).substring(digitCount - 3);
                }
            }
            if ((exp = s2.getNumberMinExponentDigitsAttribute()) == null) continue;
            result = (String)result + "+";
            int exponents = exp;
            while (--exponents >= 0) {
                result = (String)result + "0";
            }
        }
        if (!((String)mappedResult).isEmpty()) {
            result = (String)mappedResult + (String)result;
        }
        return result;
    }

    @Override
    public void setFormat(String format) {
        int openBracket = ((String)format).indexOf("[");
        String color = "";
        while (openBracket >= 0) {
            String innerText;
            int closeBracket = ((String)format).indexOf("]", openBracket);
            if (closeBracket > openBracket && (innerText = ((String)format).substring(openBracket + 1, closeBracket)).length() > 1) {
                color = OdfNumberStyle.getColorElement(innerText);
                if (!color.isEmpty()) {
                    OdfFileDom dom = (OdfFileDom)this.getOwnerDocument();
                    StyleTextPropertiesElement cProperties = new StyleTextPropertiesElement(dom);
                    cProperties.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:color", color);
                    this.appendChild(cProperties);
                }
                format = ((String)format).substring(0, openBracket) + ((String)format).substring(closeBracket + 1);
            }
            openBracket = ((String)format).indexOf("[");
        }
        if (format != null && !((String)format).equals("")) {
            Pattern p = Pattern.compile("[#0,.?/E+\\s]+");
            Matcher m4 = p.matcher((CharSequence)format);
            int lastEnd = 0;
            while (m4.find()) {
                Object prefix = "";
                if (m4.start() > lastEnd) {
                    prefix = ((String)format).substring(lastEnd, m4.start());
                }
                lastEnd = m4.end();
                String sub = ((String)format).substring(m4.start(), m4.end());
                if (sub.startsWith(" ")) {
                    int pos;
                    for (pos = 1; sub.length() > pos && sub.charAt(pos) == ' '; ++pos) {
                    }
                    prefix = (String)prefix + sub.substring(0, pos);
                    sub = sub.substring(pos);
                }
                if (!((String)prefix).isEmpty()) {
                    this.emitText((String)prefix);
                }
                String suffix = "";
                if (sub.endsWith(" ")) {
                    int pos = sub.length() - 1;
                    while (sub.charAt(pos) == ' ') {
                        --pos;
                    }
                    suffix = sub.substring(pos + 1);
                    sub = sub.substring(0, pos + 1);
                }
                boolean denominator = false;
                int denominatorCount = 0;
                int nominatorCount = 0;
                boolean isDecimals = false;
                boolean isFraction = false;
                boolean isHash = false;
                boolean isGrouping = false;
                int digitCount = 0;
                int decimalsCount = 0;
                boolean isScientific = false;
                int exponentCount = 0;
                for (int pos = 0; pos < sub.length(); ++pos) {
                    char c = sub.charAt(pos);
                    if (c == '?') {
                        isFraction = true;
                        if (denominator) {
                            ++denominatorCount;
                            continue;
                        }
                        ++nominatorCount;
                        continue;
                    }
                    if (c == '/') {
                        denominator = true;
                        continue;
                    }
                    if (c == ',') {
                        isGrouping = true;
                        continue;
                    }
                    if (c == '.') {
                        isDecimals = true;
                        continue;
                    }
                    if (c == '0') {
                        if (isScientific) {
                            ++exponentCount;
                            continue;
                        }
                        if (isDecimals) {
                            ++decimalsCount;
                            continue;
                        }
                        ++digitCount;
                        continue;
                    }
                    if (c == 'E') {
                        isScientific = true;
                        continue;
                    }
                    if (c != '#') continue;
                    isHash = true;
                }
                if (isFraction) {
                    NumberFractionElement number = new NumberFractionElement((OdfFileDom)this.getOwnerDocument());
                    if (isHash || digitCount > 0) {
                        number.setNumberMinIntegerDigitsAttribute(digitCount == 0 && isHash ? 1 : digitCount);
                    }
                    number.setNumberMinNumeratorDigitsAttribute(nominatorCount);
                    number.setNumberMinDenominatorDigitsAttribute(denominatorCount);
                    this.appendChild(number);
                } else if (isScientific) {
                    NumberScientificNumberElement number = new NumberScientificNumberElement((OdfFileDom)this.getOwnerDocument());
                    if (decimalsCount > 0) {
                        number.setNumberDecimalPlacesAttribute(decimalsCount);
                    }
                    if (digitCount > 0) {
                        number.setNumberMinIntegerDigitsAttribute(digitCount);
                    }
                    if (isGrouping) {
                        number.setNumberGroupingAttribute(true);
                    }
                    if (exponentCount > 0) {
                        number.setNumberMinExponentDigitsAttribute(exponentCount);
                    }
                    this.appendChild(number);
                } else if (sub.length() > 0) {
                    NumberNumberElement number = new NumberNumberElement((OdfFileDom)this.getOwnerDocument());
                    if (decimalsCount > 0) {
                        number.setNumberDecimalPlacesAttribute(decimalsCount);
                    }
                    if (digitCount > 0) {
                        number.setNumberMinIntegerDigitsAttribute(digitCount);
                    }
                    if (isGrouping) {
                        number.setNumberGroupingAttribute(true);
                    }
                    this.appendChild(number);
                }
                if (suffix.isEmpty()) continue;
                this.emitText(suffix);
            }
            if (lastEnd < ((String)format).length()) {
                this.emitText(((String)format).substring(lastEnd));
            }
        }
    }

    public void setMapPositive(String mapName) {
        StyleMapElement map = new StyleMapElement((OdfFileDom)this.getOwnerDocument());
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()>0");
        this.appendChild(map);
    }

    public void setMapNegative(String mapName) {
        StyleMapElement map = new StyleMapElement((OdfFileDom)this.getOwnerDocument());
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()<0");
        this.appendChild(map);
    }
}

