/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.number;

import java.util.List;
import org.odftoolkit.odfdom.dom.element.number.DataStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberElement;
import org.odftoolkit.odfdom.dom.element.number.NumberPercentageStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMapElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class OdfNumberPercentageStyle
extends NumberPercentageStyleElement {
    public OdfNumberPercentageStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfNumberPercentageStyle(OdfFileDom ownerDoc, String format, String styleName) {
        super(ownerDoc);
        this.setStyleNameAttribute(styleName);
        this.setFormat(format);
    }

    @Override
    public String getFormat(boolean caps) {
        Object result = "";
        Object mappedResult = "";
        for (Node m4 = this.getFirstChild(); m4 != null; m4 = m4.getNextSibling()) {
            if (m4 instanceof NumberNumberElement) {
                result = (String)result + this.getNumberFormat();
                continue;
            }
            if (m4 instanceof NumberTextElement) {
                String textcontent = m4.getTextContent();
                if (textcontent == null || textcontent.length() == 0) {
                    textcontent = " ";
                }
                result = (String)result + textcontent;
                continue;
            }
            if (m4 instanceof StyleTextPropertiesElement) {
                result = (String)result + this.getColorFromElement((StyleTextPropertiesElement)m4);
                continue;
            }
            if (!(m4 instanceof StyleMapElement)) continue;
            mappedResult = (String)mappedResult + this.getMapping((StyleMapElement)m4);
            mappedResult = (String)mappedResult + ";";
        }
        if (!((String)mappedResult).isEmpty()) {
            result = (String)mappedResult + (String)result;
        }
        return result;
    }

    @Override
    public void setFormat(String format) {
        List<DataStyleElement.StringToken> tokens = OdfNumberPercentageStyle.tokenize(format, DataStyleElement.NumberFormatType.FORMAT_PERCENT);
        this.emitTokens(tokens, DataStyleElement.NumberFormatType.FORMAT_PERCENT);
    }

    public void setMapPositive(String mapName) {
        StyleMapElement map = new StyleMapElement((OdfFileDom)this.getOwnerDocument());
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()>0");
        this.appendChild(map);
    }

    public void setMapNegative(String mapName) {
        StyleMapElement map = new StyleMapElement((OdfFileDom)this.getOwnerDocument());
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()<0");
        this.appendChild(map);
    }
}

