/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumFormatAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumLetterSyncAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumPrefixAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumSuffixAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextDisplayLevelsAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStartValueAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStyleNameAttribute;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleElementBase;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextListLevelStyleNumberElement
extends TextListLevelStyleElementBase {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "list-level-style-number");

    public TextListLevelStyleNumberElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getStyleNumFormatAttribute() {
        StyleNumFormatAttribute attr = (StyleNumFormatAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "num-format");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setStyleNumFormatAttribute(String styleNumFormatValue) {
        StyleNumFormatAttribute attr = new StyleNumFormatAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(styleNumFormatValue);
    }

    public Boolean getStyleNumLetterSyncAttribute() {
        StyleNumLetterSyncAttribute attr = (StyleNumLetterSyncAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "num-letter-sync");
        if (attr != null && !attr.getValue().isEmpty()) {
            return attr.booleanValue();
        }
        return null;
    }

    public void setStyleNumLetterSyncAttribute(Boolean styleNumLetterSyncValue) {
        StyleNumLetterSyncAttribute attr = new StyleNumLetterSyncAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(styleNumLetterSyncValue);
    }

    public String getStyleNumPrefixAttribute() {
        StyleNumPrefixAttribute attr = (StyleNumPrefixAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "num-prefix");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setStyleNumPrefixAttribute(String styleNumPrefixValue) {
        StyleNumPrefixAttribute attr = new StyleNumPrefixAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(styleNumPrefixValue);
    }

    public String getStyleNumSuffixAttribute() {
        StyleNumSuffixAttribute attr = (StyleNumSuffixAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "num-suffix");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setStyleNumSuffixAttribute(String styleNumSuffixValue) {
        StyleNumSuffixAttribute attr = new StyleNumSuffixAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(styleNumSuffixValue);
    }

    public Integer getTextDisplayLevelsAttribute() {
        TextDisplayLevelsAttribute attr = (TextDisplayLevelsAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "display-levels");
        if (attr != null && !attr.getValue().isEmpty()) {
            return attr.intValue();
        }
        return Integer.valueOf("1");
    }

    public void setTextDisplayLevelsAttribute(Integer textDisplayLevelsValue) {
        TextDisplayLevelsAttribute attr = new TextDisplayLevelsAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setIntValue(textDisplayLevelsValue);
    }

    public Integer getTextStartValueAttribute() {
        TextStartValueAttribute attr = (TextStartValueAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "start-value");
        if (attr != null && !attr.getValue().isEmpty()) {
            return attr.intValue();
        }
        return Integer.valueOf("1");
    }

    public void setTextStartValueAttribute(Integer textStartValueValue) {
        TextStartValueAttribute attr = new TextStartValueAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setIntValue(textStartValueValue);
    }

    public String getTextStyleNameAttribute() {
        TextStyleNameAttribute attr = (TextStyleNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "style-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextStyleNameAttribute(String textStyleNameValue) {
        TextStyleNameAttribute attr = new TextStyleNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textStyleNameValue);
    }

    public StyleTextPropertiesElement newStyleTextPropertiesElement(String textDisplayValue) {
        StyleTextPropertiesElement styleTextProperties = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleTextPropertiesElement.class);
        styleTextProperties.setTextDisplayAttribute(textDisplayValue);
        this.appendChild(styleTextProperties);
        return styleTextProperties;
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

