/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.table.TableDefaultCellStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableNumberColumnsRepeatedAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableVisibilityAttribute;
import org.odftoolkit.odfdom.dom.attribute.xml.XmlIdAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;

public class TableTableColumnElement
extends OdfStylableElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TABLE, "table-column");

    public TableTableColumnElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME, OdfStyleFamily.TableColumn, OdfName.newName(OdfDocumentNamespace.TABLE, "style-name"));
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getTableDefaultCellStyleNameAttribute() {
        TableDefaultCellStyleNameAttribute attr = (TableDefaultCellStyleNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.TABLE, "default-cell-style-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTableDefaultCellStyleNameAttribute(String tableDefaultCellStyleNameValue) {
        TableDefaultCellStyleNameAttribute attr = new TableDefaultCellStyleNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(tableDefaultCellStyleNameValue);
    }

    public Integer getTableNumberColumnsRepeatedAttribute() {
        TableNumberColumnsRepeatedAttribute attr = (TableNumberColumnsRepeatedAttribute)this.getOdfAttribute(OdfDocumentNamespace.TABLE, "number-columns-repeated");
        if (attr != null && !attr.getValue().isEmpty()) {
            return attr.intValue();
        }
        return Integer.valueOf("1");
    }

    public void setTableNumberColumnsRepeatedAttribute(Integer tableNumberColumnsRepeatedValue) {
        TableNumberColumnsRepeatedAttribute attr = new TableNumberColumnsRepeatedAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setIntValue(tableNumberColumnsRepeatedValue);
    }

    public String getTableStyleNameAttribute() {
        TableStyleNameAttribute attr = (TableStyleNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.TABLE, "style-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTableStyleNameAttribute(String tableStyleNameValue) {
        TableStyleNameAttribute attr = new TableStyleNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(tableStyleNameValue);
    }

    public String getTableVisibilityAttribute() {
        TableVisibilityAttribute attr = (TableVisibilityAttribute)this.getOdfAttribute(OdfDocumentNamespace.TABLE, "visibility");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return "visible";
    }

    public void setTableVisibilityAttribute(String tableVisibilityValue) {
        TableVisibilityAttribute attr = new TableVisibilityAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(tableVisibilityValue);
    }

    public String getXmlIdAttribute() {
        XmlIdAttribute attr = (XmlIdAttribute)this.getOdfAttribute(OdfDocumentNamespace.XML, "id");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setXmlIdAttribute(String xmlIdValue) {
        XmlIdAttribute attr = new XmlIdAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(xmlIdValue);
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    @Override
    public int getRepetition() {
        Integer repeated = this.getTableNumberColumnsRepeatedAttribute();
        if (repeated == null) {
            repeated = 1;
        }
        return repeated;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void setRepetition(int repetition) {
        this.setTableNumberColumnsRepeatedAttribute(repetition);
    }

    @Override
    public TableTableColumnElement split(int posStart) {
        TableTableColumnElement newElement = this;
        if (posStart > 0) {
            newElement = (TableTableColumnElement)this.cloneNode(true);
            int repeated = this.getTableNumberColumnsRepeatedAttribute();
            if (repeated > 1) {
                if (posStart > 1) {
                    this.setTableNumberColumnsRepeatedAttribute(posStart);
                } else {
                    this.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
                }
                if (repeated - posStart > 1) {
                    newElement.setTableNumberColumnsRepeatedAttribute(repeated - posStart);
                } else {
                    newElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
                }
            }
            Node nextNodeSibling = this.getNextSibling();
            OdfElement parent = (OdfElement)this.getParentNode();
            if (nextNodeSibling == null) {
                parent.appendChild(newElement);
            } else {
                parent.insertBefore(newElement, nextNodeSibling);
            }
        }
        return newElement;
    }
}

